/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.confluence;

import com.roninpixels.dashboardhub.gadgetsRequesters.confluence.ConfluenceBaseGadgetRequester;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingTasks
extends ConfluenceBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(PendingTasks.class);

    List retrieveTasks(String spaceKey) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("status", "incomplete");
        params.put("spaces", Arrays.asList(spaceKey));
        return this.confluenceConnector.getInlineTasks(params, null);
    }

    List<Map> retrieveAssigneesUsers(List<Map> tasks) {
        return this.confluenceConnector.getUsersAssignedTasks(tasks);
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        String spaceKey = (String)gadget.getConfig().getOtherConfig().get("spaceKey");
        try {
            List AllTasks = this.retrieveTasks(spaceKey);
            List<Map> users = this.retrieveAssigneesUsers(AllTasks);
            List<Map> tasks = this.confluenceConnector.formatTasks(AllTasks, users);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("tasks", tasks);
            URL linkUrl = new URL(this.confluenceConnector.getURL());
            if (linkUrl.getPort() > 0) {
                data.put("imageLink", String.format("%s://%s:%s", linkUrl.getProtocol(), linkUrl.getHost(), linkUrl.getPort()));
            } else {
                data.put("imageLink", String.format("%s://%s", linkUrl.getProtocol(), linkUrl.getHost()));
            }
            data.put("link", this.confluenceConnector.getURL().split("/wiki")[0]);
            return data;
        }
        catch (Exception e) {
            log.error("Something went wrong", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

