/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers;

import com.roninpixels.dashboardhub.controllers.AddonPropertiesController;
import com.roninpixels.dashboardhub.controllers.UserPropertiesController;
import com.roninpixels.dashboardhub.datasources.DatasourceGenerator;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.model.AppUser;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.PropertyModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class DatasourcesController {
    private static final Logger log = LoggerFactory.getLogger(DatasourcesController.class);
    public static final String PROPERTY_NAME = "datasources";
    @Inject
    private DHUserService dhUserService;
    @Inject
    private AddonPropertiesController propertiesController;
    @Inject
    private UserPropertiesController userPropertiesController;
    @Inject
    private DatasourceGenerator dsGenerator;
    @Inject
    private DHObjectMapper mMapper;

    public List<DatasourceModel> getDatasources(String userKey, Boolean isPrivate) throws IOException {
        PropertyModel property;
        PropertyModel propertyModel = property = isPrivate != false ? this.userPropertiesController.get(userKey, PROPERTY_NAME) : this.propertiesController.get(PROPERTY_NAME);
        if (property == null) {
            return new ArrayList<DatasourceModel>();
        }
        List<DatasourceModel> list = this.mMapper.convertValue(property.getValue(), List.class).stream().map(ds -> this.mMapper.convertValue(ds, DatasourceModel.class)).collect(Collectors.toList());
        return list;
    }

    public List<DatasourceModel> getDatasources(Boolean isPrivate) throws IOException {
        AppUser user = this.dhUserService.getLoggedInUser();
        if (user == null && isPrivate.booleanValue()) {
            throw new IllegalArgumentException("Get private datasources without a logged user is not possible");
        }
        return this.getDatasources(user == null ? null : user.getKey(), isPrivate);
    }

    public DatasourceModel getDatasource(String id, Boolean isPrivate) throws IOException {
        List<DatasourceModel> datasources = this.getDatasources(isPrivate);
        return datasources.stream().filter(ds -> ds.getId().equals(id)).findFirst().get();
    }

    public DatasourceModel getDatasource(String id, Boolean isPrivate, String userKey) throws IOException {
        List<DatasourceModel> datasources = this.getDatasources(userKey, isPrivate);
        return datasources.stream().filter(ds -> ds.getId().equals(id)).findFirst().get();
    }

    public boolean addDatasource(DatasourceModel newDs, Boolean isPrivate) throws IOException {
        List<DatasourceModel> datasources = this.getDatasources(isPrivate);
        DatasourceModel actualNewDs = this.dsGenerator.generateDatasource(newDs, datasources);
        datasources.add(actualNewDs);
        return this.updateDatasources(datasources, isPrivate);
    }

    public DatasourceModel removeDatasource(String id, Boolean isPrivate) throws IOException {
        List<DatasourceModel> datasources = this.getDatasources(isPrivate);
        DatasourceModel dsDeleted = datasources.stream().filter(ds -> ds.getId().equals(id)).findFirst().get();
        if (dsDeleted != null) {
            List<DatasourceModel> newList = datasources.stream().filter(ds -> !ds.getId().equals(id)).collect(Collectors.toList());
            this.updateDatasources(newList, isPrivate);
        }
        return dsDeleted;
    }

    public DatasourceModel removeUserDatasource(String userKey, String id) throws IOException {
        boolean isPrivate = true;
        List<DatasourceModel> datasources = this.getDatasources(userKey, true);
        DatasourceModel dsDeleted = datasources.stream().filter(ds -> ds.getId().equals(id)).findFirst().get();
        if (dsDeleted != null) {
            List<DatasourceModel> newList = datasources.stream().filter(ds -> !ds.getId().equals(id)).collect(Collectors.toList());
            this.updateUserDatasources(userKey, newList);
        }
        return dsDeleted;
    }

    public void resetRepo(Boolean isPrivate) throws IOException {
        this.updateDatasources(new ArrayList<DatasourceModel>(), isPrivate);
    }

    private boolean updateDatasources(List<DatasourceModel> newList, Boolean isPrivate) throws IOException {
        return isPrivate.booleanValue() ? null != this.userPropertiesController.createOrUpdate(PROPERTY_NAME, newList) : null != this.propertiesController.createOrUpdate(PROPERTY_NAME, newList);
    }

    private boolean updateUserDatasources(String userKey, List<DatasourceModel> newList) throws IOException {
        return this.userPropertiesController.createOrUpdate(userKey, PROPERTY_NAME, newList) != null;
    }
}

