/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.confluence.dashboardfilters.store.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.DHDashboardFilterRulesRepository;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.ao.DHFilterRule;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.store.impl.DHDashboardFilterRulesQuery;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.web.models.DashboardFilterRule;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.web.models.DashboardFilterRuleFilter;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DHDashboardFilterRulesRepositoryImpl
implements DHDashboardFilterRulesRepository {
    private static final Logger log = LoggerFactory.getLogger(DHDashboardFilterRulesRepositoryImpl.class);
    public static final String FIELD_KEY = "KEY";
    public static final String FIELD_PRIORITY = "PRIORITY";
    public static final String FIELD_DASHBOARD_LOCATION = "DASHBOARD_LOCATION";
    public static final String FIELD_WIKI_PAGE_ID = "WIKI_PAGE_ID";
    public static final String FIELD_GLOBAL_DASHBOARD_ID = "GLOBAL_DASHBOARD_ID";
    public static final String FIELD_RENDERED_AS_DASHBOARD_ACT = "RENDERED_AS_DASHBOARD";
    public static final String FIELD_RESTRICTED_TO_ALL = "RESTRICTED_TO_ALL_USERS";
    public static final String USERS_AND_GROUPS_RESTRICTED = "USERS_AND_GROUPS_RESTRICTED";
    public static final String FIELD_LAST_MODIFIED = "LAST_MODIFIED";
    @ComponentImport
    private final ActiveObjects ao;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private final DHObjectMapper mMapper;

    @Inject
    public DHDashboardFilterRulesRepositoryImpl(ActiveObjects ao, TransactionTemplate transactionTemplate, DHObjectMapper mapper) {
        this.ao = ao;
        this.transactionTemplate = transactionTemplate;
        this.mMapper = mapper;
    }

    private DHDashboardFilterRulesQuery compileQuery(DashboardFilterRuleFilter filter) {
        StringBuilder queryBuilder = new StringBuilder();
        LinkedList<String> queryParams = new LinkedList<String>();
        if (filter.getKey() != null && !filter.getKey().isEmpty()) {
            queryBuilder.append("KEY = ?");
            queryParams.add(filter.getKey());
        }
        return new DHDashboardFilterRulesQuery(queryBuilder.toString(), queryParams.toArray());
    }

    @Override
    public DashboardFilterRule getDashboardFilterRule(String key) {
        DHFilterRule dashboardFilterRule = this.findDashboardFilterRule(key);
        return dashboardFilterRule != null ? this.txDHDashboardFilterRule(dashboardFilterRule) : null;
    }

    @Override
    public DashboardFilterRule addDashboardFilterRule(DashboardFilterRule dashboardFilterRule) {
        DHFilterRule newDashboardFilterRule = (DHFilterRule)this.ao.create(DHFilterRule.class, new DBParam[]{new DBParam(FIELD_KEY, (Object)dashboardFilterRule.getKey()), new DBParam(FIELD_PRIORITY, (Object)dashboardFilterRule.getPriority()), new DBParam(FIELD_DASHBOARD_LOCATION, (Object)dashboardFilterRule.getDashboardLocation().name()), new DBParam(FIELD_WIKI_PAGE_ID, (Object)dashboardFilterRule.getWikiPageId()), new DBParam(FIELD_GLOBAL_DASHBOARD_ID, (Object)dashboardFilterRule.getGlobalDashboardId()), new DBParam(FIELD_RENDERED_AS_DASHBOARD_ACT, (Object)dashboardFilterRule.isRenderedAsDashboardAction()), new DBParam(FIELD_RESTRICTED_TO_ALL, (Object)dashboardFilterRule.isRestrictedToAllUsers()), new DBParam(USERS_AND_GROUPS_RESTRICTED, dashboardFilterRule.getUsersAndGroupsRestricted() != null ? String.join((CharSequence)",", dashboardFilterRule.getUsersAndGroupsRestricted()) : null), new DBParam(FIELD_LAST_MODIFIED, (Object)dashboardFilterRule.getLastModified())});
        newDashboardFilterRule.save();
        return this.txDHDashboardFilterRule(newDashboardFilterRule);
    }

    @Override
    public DashboardFilterRule updateDashboardFilterRule(DashboardFilterRule dashboardFilterRule) {
        DHFilterRule updatedDashboardFilterRule = (DHFilterRule)this.transactionTemplate.execute(() -> {
            DHFilterRule target = this.findDashboardFilterRule(dashboardFilterRule.getKey());
            if (target != null) {
                target.setPriority(dashboardFilterRule.getPriority());
                target.setDashboardLocation(dashboardFilterRule.getDashboardLocation().name());
                target.setWikiPageId(dashboardFilterRule.getWikiPageId());
                target.setGlobalDashboardId(dashboardFilterRule.getGlobalDashboardId());
                target.setRenderedAsDashboard(dashboardFilterRule.isRenderedAsDashboardAction());
                target.setRestrictedToAllUsers(dashboardFilterRule.isRestrictedToAllUsers());
                target.setUsersAndGroupsRestricted(dashboardFilterRule.getUsersAndGroupsRestricted() != null ? String.join((CharSequence)",", dashboardFilterRule.getUsersAndGroupsRestricted()) : null);
                target.setLastModified(dashboardFilterRule.getLastModified());
                target.save();
            }
            return target;
        });
        return updatedDashboardFilterRule != null ? this.txDHDashboardFilterRule(updatedDashboardFilterRule) : null;
    }

    @Override
    public boolean removeDashboardFilterRule(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Filter rule id cannot be null");
        }
        DHFilterRule deletedFilterRule = (DHFilterRule)this.transactionTemplate.execute(() -> {
            DHFilterRule target = this.findDashboardFilterRule(key);
            if (target != null) {
                this.ao.delete(new RawEntity[]{target});
            }
            return target;
        });
        return deletedFilterRule != null;
    }

    @Override
    public List<DashboardFilterRule> getAllDashboardFilterRules() {
        DHFilterRule[] filterRules = this.findDashboardFilterRules();
        ArrayList<DashboardFilterRule> filterRuleModels = new ArrayList<DashboardFilterRule>();
        Iterator filterRulesIt = Arrays.stream(filterRules).iterator();
        while (filterRulesIt.hasNext()) {
            DHFilterRule filterRule = (DHFilterRule)filterRulesIt.next();
            filterRuleModels.add(this.txDHDashboardFilterRule(filterRule));
        }
        return filterRuleModels;
    }

    private DashboardFilterRule txDHDashboardFilterRule(DHFilterRule dashboardFilterRule) {
        DashboardFilterRule model = new DashboardFilterRule();
        model.setKey(dashboardFilterRule.getKey());
        model.setPriority(dashboardFilterRule.getPriority());
        model.setDashboardLocation(DashboardFilterRule.DashboardLocation.valueOf(dashboardFilterRule.getDashboardLocation()));
        model.setWikiPageId(dashboardFilterRule.getWikiPageId());
        model.setGlobalDashboardId(dashboardFilterRule.getGlobalDashboardId());
        model.setRenderedAsDashboardAction(dashboardFilterRule.isRenderedAsDashboard());
        model.setRestrictedToAllUsers(dashboardFilterRule.isRestrictedToAllUsers());
        model.setUsersAndGroupsRestricted(dashboardFilterRule.getUsersAndGroupsRestricted() != null ? Arrays.asList(dashboardFilterRule.getUsersAndGroupsRestricted().split(",")) : null);
        model.setLastModified(dashboardFilterRule.getLastModified());
        return model;
    }

    private DHFilterRule findDashboardFilterRule(String key) {
        DHDashboardFilterRulesQuery query = this.compileQuery(new DashboardFilterRuleFilter(key));
        DHFilterRule[] filterRules = (DHFilterRule[])this.ao.find(DHFilterRule.class, query.compileQuery());
        if (filterRules.length == 0) {
            return null;
        }
        if (filterRules.length > 1) {
            throw new RuntimeException(String.format("There are more than one fiterRule with same key: %s", key));
        }
        return filterRules[0];
    }

    private DHFilterRule[] findDashboardFilterRules() {
        DHFilterRule[] filterRules = (DHFilterRule[])this.ao.find(DHFilterRule.class);
        return filterRules;
    }
}

