/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.jira.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.web.rest.jira.api.GenericJiraEndpoint;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/jira/v1/filters")
public class FiltersEndpoint {
    private static final Logger log = LoggerFactory.getLogger(FiltersEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response get(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @Context UriInfo ui) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            MultivaluedMap params = ui.getQueryParameters();
            HashMap<String, Object> options = new HashMap<String, Object>();
            boolean all = params.containsKey((Object)"all") ? Boolean.parseBoolean((String)params.getFirst((Object)"all")) : true;
            options.put("all", all);
            return GenericJiraEndpoint.generateResponse(jira.getAllFilters((Map<String, ?>)params, (Map<String, Object>)options));
        }
        catch (Exception e) {
            log.error("Problems getting filters", (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

