/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.utils;

import com.roninpixels.dashboardhub.utils.TokenGenerator;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.stereotype.Service;

@Service
public class TokenGeneratorImpl
implements TokenGenerator {
    @Inject
    private Crypto crypto;
    private ObjectMapper mMapper = new ObjectMapper();

    @Override
    public String generate(TokenContentModel tokenContent) {
        try {
            String rawToken = this.mMapper.writeValueAsString((Object)tokenContent);
            String encryptedToken = this.crypto.encryptBackend(rawToken);
            return encryptedToken;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems with a token generation", e);
        }
    }

    @Override
    public TokenContentModel getTokenContent(String token) {
        try {
            String json = this.crypto.decryptBackend(token);
            return (TokenContentModel)this.mMapper.readValue(json, TokenContentModel.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem recovering a token content", e);
        }
    }
}

