/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.servlet;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.UrlMode;
import com.roninpixels.dashboardhub.config.action.DHAction;
import com.roninpixels.dashboardhub.config.action.DHShowAction;
import com.roninpixels.dashboardhub.utils.TokenGeneratorImpl;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardHubServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DashboardHubServlet.class);
    private static final String RESOURCE = "resources";
    private static final String TEMPLATE_PATH = "/templates/dashboard-hub-main.vm";
    @ComponentImport
    private final TemplateRenderer templateRenderer;
    @Inject
    private TokenGeneratorImpl tokenGenerator;
    @Inject
    private Provider<DHShowAction> actionsProvider;
    private String resources;

    @Inject
    public DashboardHubServlet(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void init() {
        this.resources = this.getServletConfig().getInitParameter(RESOURCE);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map context = MacroUtils.defaultVelocityContext();
        context.put("resp", resp);
        context.put("urlMode", UrlMode.AUTO);
        context.put("scope", Collections.singletonList(this.resources));
        DHAction action = this.getAction(req);
        context.put("dh", action);
        this.templateRenderer.render(this.getTemplatePath(), context, (Writer)resp.getWriter());
    }

    protected String getTemplatePath() {
        return TEMPLATE_PATH;
    }

    protected DHAction getAction(HttpServletRequest req) {
        TokenContentModel tokenContent = this.getTokenData(req, "ac.boardToken");
        DHShowAction action = (DHShowAction)this.actionsProvider.get();
        action.setToken(tokenContent);
        return action;
    }

    protected TokenContentModel getTokenData(HttpServletRequest request, String tokenParamName) {
        String token = request.getParameter(tokenParamName);
        if (token != null) {
            try {
                return this.tokenGenerator.getTokenContent(token);
            }
            catch (Exception e) {
                log.error("Problems with a token -> " + token, (Throwable)e);
            }
        }
        return null;
    }
}

