/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.jcma.entityExporters;

import com.roninpixels.dashboardhub.jcma.entityExporters.DHExporter;
import com.roninpixels.dashboardhub.store.DHRepository;
import com.roninpixels.dashboardhub.store.DHStoreObjectCallback;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericRepositoryExporter<T>
implements DHExporter<T> {
    private static final Logger log = LoggerFactory.getLogger(GenericRepositoryExporter.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private DHRepository repo;

    public GenericRepositoryExporter(DHRepository repo) {
        this.repo = repo;
    }

    @Override
    public boolean isSingleRecord() {
        return false;
    }

    @Override
    public int export(OutputStream outputStream) {
        ExportTask task = new ExportTask(outputStream);
        this.repo.stream(task);
        return task.getCount();
    }

    protected Object prepareToExport(T modelObj) {
        return modelObj;
    }

    class ExportTask
    implements DHStoreObjectCallback<T> {
        private int count;
        private boolean isFirst = true;
        private OutputStream outputStream;

        ExportTask(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        int getCount() {
            return this.count;
        }

        @Override
        public void onObjectRead(T objModel) {
            try {
                if (this.isFirst) {
                    this.isFirst = false;
                } else {
                    this.outputStream.write(",\n".getBytes());
                }
                Object finalObj = GenericRepositoryExporter.this.prepareToExport(objModel);
                String json = mapper.writeValueAsString(finalObj);
                this.outputStream.write(json.getBytes(StandardCharsets.UTF_8));
                ++this.count;
            }
            catch (Exception e) {
                String id = this.getIDof(objModel);
                String idMsg = id == null ? "" : String.format(" (data base id = %s)", id);
                log.error(String.format("Problems migrating a \"%s\" object.", objModel.getClass(), idMsg), (Throwable)e);
            }
        }

        private String getIDof(T objModel) {
            try {
                Method method = objModel.getClass().getMethod("getId", new Class[0]);
                return "" + method.invoke(objModel, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

