/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.JSMMultiproject;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.JSMDataUtil2;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.configs.CreatedVsResolvedConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatedVsResolved
extends JSMMultiproject {
    private static final Logger log = LoggerFactory.getLogger(CreatedVsResolved.class);

    protected List getCreatedIssues(String dateFrom, String queuesJql) {
        String createdJql = String.format("created >= '%s' AND (%s)", dateFrom, queuesJql);
        return this.execJQLwithFilterFields(createdJql, Arrays.asList("created", "createdDate"), null, null, null, null);
    }

    protected List getResolvedIssues(String dateFrom, String queuesJql, boolean isServer) {
        String completedJql = String.format("%s AND (%s)", JSMDataUtil2.getResolutionQuery(dateFrom, isServer), queuesJql);
        LinkedList<String> fields = new LinkedList<String>();
        fields.add("resolutiondate");
        if (!isServer) {
            fields.add("statuscategorychangedate");
        }
        return this.execJQLwithFilterFields(completedJql, fields, null, null, null, null);
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        CreatedVsResolvedConfig config = GadgetRequesterUtils.getConfig(gadget, CreatedVsResolvedConfig.class);
        try {
            Map jqlQueuesMap = this.getJqlQueues(config);
            String dateFrom = JSMDataUtil2.getDateAsString(config.getTimeRange());
            boolean isServer = true;
            List createdIssues = this.getCreatedIssues(dateFrom, (String)jqlQueuesMap.get("jql"));
            List resolvedIssues = this.getResolvedIssues(dateFrom, (String)jqlQueuesMap.get("jql"), true);
            HashMap<String, List<Object>> data = new HashMap<String, List<Object>>();
            data.put("createdIssues", createdIssues);
            data.put("resolvedIssues", resolvedIssues);
            data.put("queues", (List<Object>)jqlQueuesMap.get("queues"));
            return data;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems getting data", e);
        }
    }
}

