/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters;

import com.roninpixels.dashboardhub.controllers.BoardPermissionsController;
import com.roninpixels.dashboardhub.controllers.BoardsController;
import com.roninpixels.dashboardhub.controllers.DatasourcePermissionsController;
import com.roninpixels.dashboardhub.controllers.gadgets.GadgetModelsFactory;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequesterException;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.GadgetRequestModel;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.controllers.DatasourcesController;
import com.roninpixels.dashboardhub.utils.TokenGenerator;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import java.io.IOException;
import java.util.Collection;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class SecureGadgetDefProviderSrv {
    @Inject
    private BoardsController boardsController;
    @Inject
    private DatasourcesController dsController;
    @Inject
    private TokenGenerator tokenGenerator;
    @Inject
    private BoardPermissionsController boardPermissionsController;
    @Inject
    private DatasourcePermissionsController dsPermissionsController;
    @Inject
    private GadgetModelsFactory gadgetModelsFactory;
    @Inject
    private DHUserService userService;

    public void checkAccess(BoardModel board) throws GadgetRequesterException {
        if (board == null) {
            throw new GadgetRequesterException("Not found", 404);
        }
        String userKey = this.userService.getLoggedInUserKey();
        boolean allowedBoard = this.boardPermissionsController.isBoardVisibleFor(board, userKey);
        if (!allowedBoard) {
            throw new GadgetRequesterException("Forbidden", 403);
        }
    }

    private GadgetModel getGadgetFromBoard(GadgetRequestModel gadgetRequest, TokenContentModel token) throws GadgetRequesterException {
        BoardModel storedBoard = this.boardsController.getBoard(token.getBoardId());
        this.checkAccess(storedBoard);
        String requestedGadgetId = gadgetRequest.getGadgetId() != null ? gadgetRequest.getGadgetId() : gadgetRequest.getGadget().getId();
        GadgetModel storedGadget = storedBoard.getData().stream().flatMap(Collection::stream).filter(gadget -> requestedGadgetId.equals(gadget.getId())).findAny().orElse(null);
        if (storedGadget != null) {
            this.retrieveAndPopulateDS(storedGadget);
        }
        return storedGadget;
    }

    public GadgetModel checkAndGetStoredGadget(GadgetRequestModel gadgetRequest) throws GadgetRequesterException {
        TokenContentModel token = this.tokenGenerator.getTokenContent(gadgetRequest.getBoardToken());
        if (token.getBoardId() != null) {
            return this.getGadgetFromBoard(gadgetRequest, token);
        }
        if (token.getContainerId() != null && token.getItemId() != null) {
            return this.gadgetModelsFactory.getGadgetByToken(token);
        }
        throw new GadgetRequesterException("INVALID_GADGET", 400);
    }

    public GadgetModel checkAndGetGadgetByRequest(GadgetRequestModel gadgetRequest) throws GadgetRequesterException {
        GadgetModel requestedGadget = gadgetRequest.getGadget();
        GadgetModel storedGadget = gadgetRequest.getBoardToken() == null ? null : this.checkAndGetStoredGadget(gadgetRequest);
        String requestedDsId = requestedGadget.getConfig().getDatasource().getId();
        if (storedGadget != null && requestedDsId.equals(storedGadget.getConfig().getDatasource().getId())) {
            requestedGadget.getConfig().setDatasource(storedGadget.getConfig().getDatasource());
        } else {
            DatasourceModel requestedDS = this.retrieveAndPopulateDS(requestedGadget);
            if (!this.dsPermissionsController.isLoggedInUserAllowedToUse(requestedDS)) {
                throw new GadgetRequesterException("Forbidden - invalid gadget", 403);
            }
        }
        return gadgetRequest.getGadget();
    }

    private DatasourceModel retrieveAndPopulateDS(GadgetModel gadget) throws GadgetRequesterException {
        DatasourceModel ds = null;
        try {
            ds = this.dsController.getDatasource(gadget.getConfig().getDatasource().getId());
            gadget.getConfig().setDatasource(ds);
        }
        catch (IOException ioe) {
            throw new GadgetRequesterException("Invalid datasource", 500);
        }
        return ds;
    }
}

