/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.exceptions;

import java.util.Arrays;
import java.util.Map;
import org.springframework.http.ResponseEntity;

public class BadRequestToSourceException
extends RuntimeException {
    private final int statusCode;
    private final ResponseEntity responseEntity;
    private final String body;

    public BadRequestToSourceException(int statusCode, String body, ResponseEntity responseEntity) {
        this.statusCode = statusCode;
        this.body = body;
        this.responseEntity = responseEntity;
    }

    public BadRequestToSourceException(int statusCode, String body) {
        this(statusCode, body, null);
    }

    public BadRequestToSourceException(ResponseEntity responseEntity) {
        this(responseEntity.getStatusCode().value(), null, responseEntity);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public ResponseEntity getResponseEntity() {
        return this.responseEntity;
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public String getMessage() {
        String msg = null;
        if (this.responseEntity != null) {
            Object rawResponse = this.responseEntity.getBody();
            if (rawResponse instanceof Map) {
                StringBuilder sb = new StringBuilder();
                sb.append("Status code: ").append(this.responseEntity.getStatusCodeValue());
                Arrays.asList("message", "reason").forEach(key -> {
                    if (((Map)rawResponse).containsKey(key)) {
                        Object value = ((Map)rawResponse).get(key);
                        String valueStr = null;
                        if (!(value instanceof String)) {
                            valueStr = value.toString();
                        } else if (!((String)value).isEmpty()) {
                            valueStr = value;
                        }
                        if (valueStr != null) {
                            sb.append(" (").append((String)key).append(" = ").append((Object)valueStr).append(")");
                        }
                    }
                });
                msg = sb.toString();
            } else if (rawResponse != null) {
                msg = rawResponse.toString();
            }
        }
        return msg != null ? msg : super.getMessage();
    }
}

