/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.datasources.generators;

import com.roninpixels.dashboardhub.connectors.ConnectorsFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.datasources.generators.Generator;
import com.roninpixels.dashboardhub.globals.ProductHosting;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.stereotype.Component;

@Component(value="JiraConfBitbucketDatacenter")
public class JiraConfBitbucketDatacenter
implements Generator {
    @Inject
    private Crypto mCrypto;
    @Inject
    private ConnectorsFactory connectorsFactory;
    static final List<String> PRODUCTS = Arrays.asList("jira", "confluence", "bitbucket");

    @Override
    public boolean match(DatasourceModel def) {
        DsOptionsModel options = def.getOptions();
        return PRODUCTS.contains(def.getProduct()) && options != null && options.getOption(ProductHosting.DATACENTER.value(), String.class) != null;
    }

    @Override
    public DatasourceModel generateDS(DatasourceModel dsDef, List<DatasourceModel> datasources, DsOptionsModel options, Object req, Object res) throws Exception {
        String id = UUID.randomUUID().toString();
        DatasourceModel newDs = new DatasourceModel();
        newDs.setId(id);
        newDs.setName(dsDef.getName().trim());
        newDs.setPrivate(dsDef.getPrivate());
        newDs.setUrl(dsDef.getUrl().trim());
        newDs.setType("datacenter");
        newDs.setProduct(dsDef.getProduct());
        newDs.setCreator(dsDef.getCreator());
        newDs.setCreated(new Date());
        DsOptionsModel tokenData = new DsOptionsModel();
        tokenData.addOtherConfig("id", id);
        tokenData.addOtherConfig("url", dsDef.getUrl());
        tokenData.addOtherConfig("options", options);
        tokenData.addOtherConfig(newDs.getType(), true);
        ObjectMapper mapper = new ObjectMapper();
        String token = this.mCrypto.encryptBackend(mapper.writeValueAsString((Object)tokenData));
        newDs.setToken(token);
        this.validate(newDs, datasources);
        return newDs;
    }

    public void validate(DatasourceModel dsDef, List<DatasourceModel> datasources) {
        if (dsDef.getUrl().trim().isEmpty()) {
            throw new RuntimeException("INVALID_INSTANCE");
        }
        boolean alreadyExists = datasources.stream().anyMatch(ds -> ds.getName().equalsIgnoreCase(dsDef.getName()));
        if (alreadyExists) {
            throw new RuntimeException("CONFLICT");
        }
        try {
            DHConnector connector = this.connectorsFactory.getConnector(dsDef);
            if (!connector.isValid()) {
                throw new RuntimeException("INVALID_INSTANCE");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("INVALID_INSTANCE", e);
        }
    }
}

