/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.confluence.cloud.functions;

import com.roninpixels.dashboardhub.connectors.impl.confluence.cloud.functions.ConfluenceCloudV2BaseFunc;
import com.roninpixels.dashboardhub.connectors.impl.confluence.cloud.functions.GetSpacesCloudV2Func;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetInlineTasksCloudV2Func
extends ConfluenceCloudV2BaseFunc {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetInlineTasksCloudV2Func.class);
    public static final String PATH = "/api/v2/tasks";
    public static final String EXTRACT_USER_ID_FROM_BODY_PATTERN = "<ac:link><ri:user (ri:account-id=\"([0-9a-z:-]+)\"|ri:user-name=\"([0-9a-z:-]+)\"|ri:accountId=\"([0-9a-z:-]+)\"|ri:username=\"([0-9a-z:-]+)\") \\/><\\/ac:link>";
    public static final String EXTRACT_DATE_PATTERN = "<time datetime=\"([0-9]{4}-[0-9]{2}-[0-9]{2})\" \\/>";
    public static final Map OPTIONS_GET_ALL = Collections.singletonMap("all", true);
    private static ObjectMapper mapper = new ObjectMapper();

    public GetInlineTasksCloudV2Func(ServerConnector connector) {
        super(connector);
    }

    public static final Map getInlineUsersTaskMap(List<Map> tasks) {
        LinkedHashMap<String, List<String>> inlineUsersTaskMap = new LinkedHashMap<String, List<String>>();
        for (Map task : tasks) {
            String contentId = String.valueOf(task.getOrDefault("pageId", task.get("blogPostId")));
            String taskId = String.valueOf(task.get("id"));
            List<String> inlineUsersIds = GetInlineTasksCloudV2Func.getUsersAssigned(task);
            inlineUsersTaskMap.put(String.format("%s-%s", taskId, contentId), inlineUsersIds);
        }
        return inlineUsersTaskMap;
    }

    public static final List<Map> formatTasks(List<Map> tasks, Map inlineUsersTaskMap, Map userMap, List<Map> contents) {
        return tasks.stream().map(task -> {
            String contentId = String.valueOf(task.getOrDefault("pageId", task.get("blogPostId")));
            LinkedHashMap formattedTask = new LinkedHashMap();
            formattedTask.put("taskId", task.get("id"));
            formattedTask.put("contentId", contentId);
            Map contentMap = contents != null ? (Map)contents.stream().filter(content -> content.get("id").equals(contentId)).findFirst().orElse(null) : null;
            formattedTask.put("title", contentMap != null ? contentMap.get("title") : contentId);
            String taskBodyStorage = (String)((Map)((Map)task.get("body")).get("storage")).get("value");
            formattedTask.put("body", GetInlineTasksCloudV2Func.parseTaskBody(taskBodyStorage, userMap));
            String inlineKey = task.get("id") + "-" + contentId;
            if (inlineUsersTaskMap.containsKey(inlineKey)) {
                List inlineUsersIds = (List)inlineUsersTaskMap.get(inlineKey);
                formattedTask.put("assignees", inlineUsersIds.stream().map(inlineUserId -> userMap.get(inlineUserId)).filter(user -> user != null).collect(Collectors.toList()));
            }
            return formattedTask;
        }).collect(Collectors.toList());
    }

    static final String parseTaskBody(String str, Map userMap) {
        String SEPARATOR_STRING = "##DASHBOARDS_SEPARATOR##";
        String strCopy = str;
        String userRegex = EXTRACT_USER_ID_FROM_BODY_PATTERN;
        Pattern userPattern = Pattern.compile(userRegex, 10);
        Matcher userMatcher = userPattern.matcher(str);
        while (userMatcher.find()) {
            String userId = userMatcher.group(2);
            if (userId == null) continue;
            if (!userMap.containsKey(userId)) {
                strCopy = strCopy.replace(userMatcher.group(0), "<span class=\"pending-task-bold\">" + userId + " (Unlicensed user)</span>");
                continue;
            }
            Map user = (Map)userMap.get(userId);
            String displayName = (String)user.get("displayName");
            strCopy = strCopy.replace(userMatcher.group(0), "<span class=\"pending-task-bold\">" + displayName + "</span>");
        }
        String dateRegex = EXTRACT_DATE_PATTERN;
        Pattern datePattern = Pattern.compile(dateRegex, 10);
        Matcher dateMatcher = datePattern.matcher(strCopy);
        while (dateMatcher.find()) {
            String dateMatch = dateMatcher.group(1);
            if (dateMatch == null) continue;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat finalSimpleDateFormat = new SimpleDateFormat("EEE, MMM d");
            try {
                Date newDate = simpleDateFormat.parse(dateMatch);
                String formattedDate = finalSimpleDateFormat.format(newDate);
                strCopy = strCopy.replace(dateMatcher.group(0), "<span class=\"pending-task-date\">" + formattedDate + "</span>");
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        strCopy = strCopy.replace("<ac:link ", SEPARATOR_STRING + "<ac:link ");
        strCopy = strCopy.replace("</ac:link>", "</ac:link>" + SEPARATOR_STRING);
        strCopy = String.join((CharSequence)"", strCopy.split(SEPARATOR_STRING));
        strCopy = strCopy.replaceAll("<ac:link ", "<span class=\"pending-task-bold\" ").replaceAll("</ac:link>", "</span>");
        return strCopy;
    }

    public static List<String> getUsersAssigned(Map task) {
        LinkedList<String> ids = new LinkedList<String>();
        try {
            String atlasDocFormat = (String)((Map)((Map)task.get("body")).get("atlas_doc_format")).get("value");
            Map doc = (Map)mapper.readValue(atlasDocFormat, Map.class);
            List elements = (List)doc.get("content");
            while (!elements.isEmpty()) {
                Map current = (Map)elements.remove(0);
                if ("mention".equals(current.get("type"))) {
                    ids.add((String)((Map)current.get("attrs")).get("id"));
                    continue;
                }
                if (!current.containsKey("content")) continue;
                elements.addAll((List)current.get("content"));
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Problems reading a task. It will be ignored. (id = %s)", task.get("id")), (Throwable)e);
        }
        return ids;
    }

    public static List<String> getUsersAssignedTasks(List<Map> tasks) {
        List<String> accountIds = tasks.stream().map(GetInlineTasksCloudV2Func::getUsersAssigned).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        return accountIds;
    }

    List<String> getSpaceIds(List<String> spaceKeys) {
        Map<String, List<String>> params = Collections.singletonMap("keys", spaceKeys);
        List spaces = (List)new GetSpacesCloudV2Func(this.connector).getSpaces(params, OPTIONS_GET_ALL).getBody();
        return spaces.stream().map(space -> (String)space.get("id")).collect(Collectors.toList());
    }

    public List<Map> getTasks(Map params) {
        HashMap mParams = new HashMap();
        if (params.containsKey("status")) {
            mParams.put("status", params.get("status"));
        }
        if (params.containsKey("limit")) {
            mParams.put("limit", params.get("limit"));
        }
        if (params.containsKey("task-id")) {
            mParams.put("task-id", params.get("task-id"));
        }
        if (params.containsKey("spaceIds")) {
            mParams.put("space-id", params.get("spaceIds"));
        } else if (params.containsKey("spaces")) {
            List<String> spaceIds = this.getSpaceIds((List)params.get("spaces"));
            mParams.put("space-id", spaceIds);
        }
        mParams.put("body-format", params.getOrDefault("body-format", "atlas_doc_format"));
        List fullTasks = this.getAllElements(PATH, mParams, OPTIONS_GET_ALL, 300);
        return fullTasks;
    }
}

