/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors;

import com.roninpixels.dashboardhub.connectors.ConnectorsFactory;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.DatasourceInfo;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.controllers.DatasourcesControllerV2;
import com.roninpixels.dashboardhub.controllers.gadgets.GadgetModelsFactory;
import com.roninpixels.dashboardhub.controllers.gadgets.GadgetsRequesterController;
import com.roninpixels.dashboardhub.exceptions.BadDatasourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.GadgetRequestModel;
import com.roninpixels.dashboardhub.utils.TokenGeneratorImpl;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConnectorsProviderImpl
implements ConnectorsProvider {
    private static final Logger log = LoggerFactory.getLogger(ConnectorsProviderImpl.class);
    private static final String TAG_DATASOURCE = "datasource";
    private static final String TAG_BOARD = "board";
    private static final String TAG_GADGET = "gadget";
    @Inject
    private ConnectorsFactory factory;
    @Inject
    private GadgetsRequesterController grController;
    @Inject
    private DatasourcesControllerV2 dsController;
    @Inject
    private TokenGeneratorImpl tokenGenerator;
    @Inject
    private GadgetModelsFactory gadgetModelsFactory;
    private ObjectMapper mapper = new ObjectMapper();

    @Override
    public DHConnector getConnector(DatasourceModel datasource) {
        return this.factory.getConnector(datasource);
    }

    @Override
    public DHConnector getConnectorFromEncryptedDs(String datasourceInfo) {
        try {
            DatasourceModel ds = this.getDatasourceFrom(datasourceInfo);
            return this.getConnector(ds);
        }
        catch (Exception e) {
            throw new BadDatasourceException(datasourceInfo, e);
        }
    }

    @Override
    public DatasourceModel getDatasourceFrom(String datasourceInfo) throws Exception {
        String rawInfo = new String(Base64.getDecoder().decode(datasourceInfo));
        Map dsInfoUnknown = (Map)this.mapper.readValue(rawInfo, Map.class);
        if (dsInfoUnknown.containsKey(TAG_BOARD)) {
            DatasourceInfo dsInfo = (DatasourceInfo)this.mapper.convertValue((Object)dsInfoUnknown, DatasourceInfo.class);
            GadgetRequestModel grm = new GadgetRequestModel();
            grm.setBoardToken(dsInfo.getBoard());
            grm.setGadgetId(dsInfo.getGadget().getId());
            grm.setSlideIndex(dsInfo.getGadget().getSlide());
            grm.setGadgetIndex(dsInfo.getGadget().getIndex());
            GadgetModel gadget = this.grController.findGadgetWithDatasource(grm);
            return gadget.getConfig().getDatasource();
        }
        if (dsInfoUnknown.containsKey(TAG_DATASOURCE)) {
            DatasourceModel ds = (DatasourceModel)this.mapper.convertValue(dsInfoUnknown.get(TAG_DATASOURCE), DatasourceModel.class);
            return this.dsController.getDatasource(ds.getId());
        }
        if (dsInfoUnknown.containsKey(TAG_GADGET)) {
            String token = (String)((HashMap)this.mapper.convertValue(dsInfoUnknown.get(TAG_GADGET), HashMap.class)).get("token");
            TokenContentModel tokenContent = this.tokenGenerator.getTokenContent(token);
            GadgetModel gadget = this.gadgetModelsFactory.getGadgetByToken(tokenContent);
            return this.dsController.getDatasource(gadget.getConfig().getDatasource().getId());
        }
        log.error("Datasource definition not supported: " + rawInfo);
        return null;
    }
}

