/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.dashboardHub.gadgetsRequester;

import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequesterException;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetsRequestService;
import com.roninpixels.dashboardhub.gadgetsRequesters.SecureGadgetDefProviderSrv;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.GadgetRequestModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.Collections;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/board/memory/gadget")
public class MemoryGadgetEndpoint {
    private static final Logger log = LoggerFactory.getLogger(MemoryGadgetEndpoint.class);
    @Inject
    private GadgetsRequestService grService;
    @Inject
    private SecureGadgetDefProviderSrv grSecurityCheckerSrv;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doRequest(GadgetRequestModel gadgetRequest) {
        GadgetModel gadget = null;
        try {
            gadget = this.grSecurityCheckerSrv.checkAndGetGadgetByRequest(gadgetRequest);
        }
        catch (GadgetRequesterException e) {
            log.error("Problems getting the gadget related to the ", (Throwable)e);
            return ResponseBuilder.createErrorFrom(e);
        }
        return this.grService.doRequest(gadget, gadgetRequest.getExtraParams(), Collections.emptyMap());
    }
}

