/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.utils.crypto.impl;

import com.roninpixels.dashboardhub.utils.crypto.RSACryptoService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.annotation.PostConstruct;
import javax.crypto.Cipher;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSACryptoServiceImpl
implements RSACryptoService {
    private static final Logger log = LoggerFactory.getLogger(RSACryptoServiceImpl.class);
    private Cipher decryptCipher;
    private Cipher encryptCipher;

    private Cipher initKey(int mode, InputStream keyInputStream) throws GeneralSecurityException, IOException {
        Cipher result = Cipher.getInstance("RSA");
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        byte[] rawKeyBytes = IOUtils.toByteArray((InputStream)keyInputStream);
        String key = new String(rawKeyBytes, StandardCharsets.UTF_8);
        String keyPEM = key.replaceAll("-----(BEGIN|END) (PRIVATE|PUBLIC) KEY-----", "").replaceAll(System.lineSeparator(), "");
        byte[] KeyBytes = Base64.getDecoder().decode(keyPEM);
        if (mode == 2) {
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(KeyBytes);
            PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
            result.init(2, privateKey);
        } else if (mode == 1) {
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(KeyBytes);
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            result.init(1, publicKey);
        } else {
            throw new UnsupportedOperationException("Cipher mode not supported: " + mode);
        }
        return result;
    }

    private void initPrivateKey() throws GeneralSecurityException, IOException {
        InputStream keyInputStream = RSACryptoServiceImpl.class.getClassLoader().getResourceAsStream("dh.jcma.private.key");
        if (keyInputStream == null) {
            log.info("RSA private key is not present");
            return;
        }
        this.decryptCipher = this.initKey(2, keyInputStream);
    }

    private void initPublicKey() throws GeneralSecurityException, IOException {
        InputStream keyInputStream = RSACryptoServiceImpl.class.getClassLoader().getResourceAsStream("dh.jcma.public.key");
        if (keyInputStream == null) {
            log.info("RSA public key is not present");
            return;
        }
        this.encryptCipher = this.initKey(1, keyInputStream);
    }

    @PostConstruct
    public void init() {
        try {
            this.initPrivateKey();
            this.initPublicKey();
        }
        catch (IOException | GeneralSecurityException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String encrypt(String data) throws GeneralSecurityException {
        if (this.encryptCipher == null) {
            throw new RuntimeException("public RSA key couldn't be loaded");
        }
        byte[] encryptedBytes = this.encryptCipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
        String base64EncryptedMsg = Base64.getEncoder().encodeToString(encryptedBytes);
        return base64EncryptedMsg;
    }

    @Override
    public String decrypt(String encryptedData) throws GeneralSecurityException {
        if (this.decryptCipher == null) {
            throw new RuntimeException("private RSA key couldn't be loaded");
        }
        byte[] encryptedMsgBytes = Base64.getDecoder().decode(encryptedData);
        byte[] encryptedBytes = this.decryptCipher.doFinal(encryptedMsgBytes);
        return new String(encryptedBytes, StandardCharsets.UTF_8);
    }
}

