/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.license;

import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Date;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LicenseStatusJsonBean {
    private boolean isValid;
    private String name;
    private String key;
    private String type;
    private String error;
    private Date expirationTime;
    private Duration timeBeforeExpiry;

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean valid) {
        this.isValid = valid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public Duration getTimeBeforeExpiry() {
        return this.timeBeforeExpiry;
    }

    public void setTimeBeforeExpiry(Duration timeBeforeExpiry) {
        this.timeBeforeExpiry = timeBeforeExpiry;
    }

    public static LicenseStatusJsonBean shortBean(PluginLicense pluginLicense) {
        if (pluginLicense == null) {
            return null;
        }
        LicenseStatusJsonBean bean = new LicenseStatusJsonBean();
        bean.name = pluginLicense.getPluginName();
        bean.key = pluginLicense.getPluginKey();
        bean.type = pluginLicense.getLicenseType().name();
        bean.isValid = pluginLicense.isValid();
        if (pluginLicense.getExpiryZonedDate().isPresent()) {
            bean.expirationTime = Date.from(((ZonedDateTime)pluginLicense.getExpiryZonedDate().get()).toInstant());
        }
        if (pluginLicense.getDurationBeforeExpiry().isPresent()) {
            bean.timeBeforeExpiry = (Duration)pluginLicense.getDurationBeforeExpiry().get();
        }
        bean.error = pluginLicense.getError().isDefined() ? ((LicenseError)pluginLicense.getError().get()).name() : null;
        return bean;
    }
}

