/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.jcma.entityExporters.impl;

import com.roninpixels.dashboardhub.config.frontedModel.AppConfigModel;
import com.roninpixels.dashboardhub.controllers.AccessManagementController;
import com.roninpixels.dashboardhub.jcma.entityExporters.DHExporter;
import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppConfigExporter
implements DHExporter<AppConfigModel> {
    private static final Logger log = LoggerFactory.getLogger(AppConfigExporter.class);
    public static final String LABEL = "SavedAppConfigEntity";
    @Inject
    private AccessManagementController accessManagementController;
    private ObjectMapper mapper = new ObjectMapper();

    @Override
    public int export(OutputStream outputStream) {
        try {
            AppConfigModel appConfig = this.accessManagementController.getAdminConfig();
            this.mapper.writeValue(outputStream, (Object)appConfig);
            return 1;
        }
        catch (IOException e) {
            log.error("Problems writing the app configuration", (Throwable)e);
            return 0;
        }
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public boolean isSingleRecord() {
        return true;
    }
}

