/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.opsgenie;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.opsgenie.OnCallSchedulesConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.opsgenie.OpsgenieGadgetRequesterBase;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class OnCallSchedules
extends OpsgenieGadgetRequesterBase {
    private static final int MAX_RETRIES = 3;
    private static final long SLEEP_TIME_TOO_MANY_RQS = 30000L;
    private static final long SLEEP_TIME_BETWEEN_RQS = 1L;
    private static final Logger log = LoggerFactory.getLogger(OnCallSchedules.class);
    public static final String DEFAULT_TIMEPERIOD_INTERVAL = "1";

    Map getATimeline(String id, Map<String, String> params) throws Exception {
        int count = 0;
        boolean retry = true;
        ResponseEntity<String> response = null;
        while (retry) {
            response = this.connector.getScheduleTimeline(id, params);
            retry = response.getStatusCode() == HttpStatus.TOO_MANY_REQUESTS && count < 3;
            ++count;
            if (!retry) continue;
            Thread.sleep(30000L);
        }
        return this.checkStatusAndParse(response, Map.class);
    }

    List getTimelines(OnCallSchedulesConfig config) throws Exception {
        LinkedList<Map> timelines = new LinkedList<Map>();
        Iterator<Map> it = config.getSchedules().iterator();
        HashMap<String, String> params = new HashMap<String, String>();
        if (config.getTimePeriod() != null) {
            params.put("intervalUnit", String.valueOf(config.getTimePeriod().get("id")));
            params.put("interval", DEFAULT_TIMEPERIOD_INTERVAL);
        }
        params.putIfAbsent("pagelen", DEFAULT_TIMEPERIOD_INTERVAL);
        while (it.hasNext()) {
            Map aSchedule = it.next();
            String id = (String)aSchedule.get("id");
            timelines.add(this.getATimeline(id, params));
            if (!it.hasNext()) continue;
            Thread.sleep(1L);
        }
        return timelines;
    }

    @Override
    List getUsers() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("loadAll", "true");
        ResponseEntity<List> resp = this.connector.listUsers(params);
        this.checkStatus(resp);
        return (List)resp.getBody();
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        OnCallSchedulesConfig config = GadgetRequesterUtils.getConfig(gadget, OnCallSchedulesConfig.class);
        boolean getUsers = this.checkGetUsers(extraParams);
        try {
            List timelines = this.getTimelines(config);
            HashMap<String, List> data = new HashMap<String, List>();
            data.put("timelines", timelines);
            if (getUsers && !timelines.isEmpty()) {
                data.put("users", this.getUsers());
            }
            return data;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            log.error("Something went wrong", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

