/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.confluence;

import com.roninpixels.dashboardhub.gadgetsRequesters.confluence.ConfluenceBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customChartsConfig.CQLSearchConfig;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQLSearch
extends ConfluenceBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(CQLSearch.class);
    private static final List<String> DEFAULT_FIELDS = Arrays.asList(new String[0]);
    private static final List<String> EXPAND_OPTIONALS = Arrays.asList("metadata.labels", "history", "history.lastUpdated", "history.lastUpdated.collaborators", "history.lastUpdated.collaborators.users");
    private static final Map<String, String> EXPANDERS = new HashMap<String, String>();

    protected String getExpandValue(String fieldKey) {
        return EXPANDERS.get(fieldKey);
    }

    protected String getCQL(CQLSearchConfig config) {
        return config.getCql();
    }

    protected List<String> getDefaultFields() {
        return new LinkedList<String>(DEFAULT_FIELDS);
    }

    protected List<String> getExpandValue(CQLSearchConfig config) {
        List<String> fields = this.getDefaultFields();
        fields.addAll(config.getColumnsAndFields());
        LinkedList<String> expanders = new LinkedList<String>();
        if (fields.isEmpty()) {
            expanders.addAll(EXPAND_OPTIONALS);
        } else {
            expanders.addAll(fields.stream().distinct().map(this::getExpandValue).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return expanders.stream().distinct().collect(Collectors.toList());
    }

    protected Map execCQL(CQLSearchConfig config) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cql", this.getCQL(config));
        params.put("expand", String.join((CharSequence)",", this.getExpandValue(config)));
        List content = this.confluenceConnector.execCQL(params, Collections.emptyMap());
        String link = this.confluenceConnector.getURL().split("/wiki")[0];
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("content", content);
        data.put("link", link);
        return data;
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        CQLSearchConfig config = GadgetRequesterUtils.getConfig(gadget, CQLSearchConfig.class);
        Map data = this.execCQL(config);
        return data;
    }

    static {
        EXPANDERS.put("SPACE", "space.icon");
        EXPANDERS.put("CONTAINER", "container");
        EXPANDERS.put("LABELS", "metadata.labels");
        EXPANDERS.put("CREATOR", "history");
        EXPANDERS.put("CREATED_DATE", "history");
        EXPANDERS.put("LAST_MODIFIER", "history.lastUpdated.collaborators.users");
        EXPANDERS.put("LAST_MODIFIED_DATE", "history.lastUpdated");
    }
}

