/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.bitbucket;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.BitbucketConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.bitbucket.configBeans.ProjectRepo;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

public abstract class BitbucketGadgetRequesterBase
implements GadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(BitbucketGadgetRequesterBase.class);
    @Inject
    private ConnectorsProvider provider;
    BitbucketConnector connector;
    private ObjectMapper mapper = new ObjectMapper();
    protected Map context;
    static final Comparator<Map> PIPELINE_COMPARATOR = Comparator.comparing(pl -> ZonedDateTime.parse((String)pl.get("created_on")));

    @Override
    public void init(DatasourceModel datasource, Map context) {
        this.connector = (BitbucketConnector)this.provider.getConnector(datasource);
        if (this.connector == null) {
            throw new IllegalArgumentException("Datasource is not valid for gadget requester: " + this.getClass().getAnnotation(Component.class));
        }
        this.context = context;
    }

    protected void checkStatus(ResponseEntity<?> response) {
        if (response.getStatusCode().value() >= 400) {
            throw new BadRequestToSourceException(response);
        }
    }

    List<Map> getPullRequestsUtil(List<ProjectRepo> projectRepos, Map<String, String> params, boolean loadAll) {
        return projectRepos.parallelStream().map(prjAndRepo -> {
            String prj = prjAndRepo.getProjectKey();
            String slug = prjAndRepo.getRepoSlug();
            ResponseEntity<List> res = this.connector.getPullRequests(prj, slug, params, loadAll);
            this.checkStatus(res);
            return (List)res.getBody();
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    List<Map> enrichPrsUtil(List<Map> prs, List<String> expand) {
        return prs.parallelStream().map(pr -> (Map)this.connector.getPrInfo((Map)pr, expand).getBody()).collect(Collectors.toList());
    }

    List<Map> getPipelinesUtil(List<String> repos, Map<String, String> params) {
        return repos.parallelStream().map(slug -> {
            ResponseEntity<List> res = this.connector.getPipelines((String)slug, params);
            this.checkStatus(res);
            List pipelines = (List)res.getBody();
            pipelines.stream().forEach(pipeline -> pipeline.put("slug", slug));
            return pipelines;
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    List<Map> sortPipelines(List<Map> pipelines) {
        return pipelines.stream().sorted(PIPELINE_COMPARATOR.reversed()).collect(Collectors.toList());
    }

    Map findCommit(Map pipeline) {
        Map target = (Map)pipeline.get("target");
        return target != null && target.containsKey("commit") ? (Map)target.get("commit") : null;
    }
}

