/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.datasources.generators;

import com.roninpixels.dashboardhub.connectors.ConnectorsFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.datasources.generators.Generator;
import com.roninpixels.dashboardhub.globals.Product;
import com.roninpixels.dashboardhub.globals.ProductHosting;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.stereotype.Component;

@Component(value="JiraConfBitbucketCloud")
public class JiraConfBitbucketCloud
implements Generator {
    @Inject
    private Crypto mCrypto;
    @Inject
    private ConnectorsFactory connectorsFactory;
    private static final List<String> PRODUCTS = Arrays.asList(Product.JIRA.value(), Product.CONFLUENCE.value(), Product.BITBUCKET.value());

    @Override
    public boolean match(DatasourceModel def) {
        DsOptionsModel options = def.getOptions();
        boolean isDatacenter = false;
        if (options != null) {
            Object datacenterOption = options.getOtherConfig().get(ProductHosting.DATACENTER.value());
            boolean bl = isDatacenter = datacenterOption != null && Boolean.TRUE.equals(datacenterOption);
            if (!isDatacenter) {
                String hostType = options.getOption("hostType", String.class);
                Boolean datacenter = hostType != null && ProductHosting.DATACENTER.value().equals(hostType);
                isDatacenter = datacenter != null && datacenter != false;
            }
        }
        return !isDatacenter && PRODUCTS.contains(def.getProduct());
    }

    @Override
    public DatasourceModel generateDS(DatasourceModel dsDef, List<DatasourceModel> datasources, DsOptionsModel options, Object req, Object res) throws Exception {
        String id = UUID.randomUUID().toString();
        DatasourceModel newDs = new DatasourceModel();
        newDs.setId(id);
        newDs.setName(dsDef.getName().trim());
        newDs.setPrivate(dsDef.getPrivate());
        newDs.setUrl(dsDef.getUrl().trim());
        newDs.setType(ProductHosting.CLOUD.value());
        newDs.setProduct(dsDef.getProduct());
        newDs.setCreator(dsDef.getCreator());
        newDs.setCreated(new Date());
        DsOptionsModel tokenData = this.generateDsOptions(newDs, options);
        ObjectMapper mapper = new ObjectMapper();
        String token = this.mCrypto.encryptBackend(mapper.writeValueAsString((Object)tokenData));
        newDs.setToken(token);
        this.validate(newDs, datasources);
        return newDs;
    }

    DsOptionsModel generateDsOptions(DatasourceModel ds, DsOptionsModel options) {
        DsOptionsModel tokenData = new DsOptionsModel();
        tokenData.addOtherConfig("id", ds.getId());
        tokenData.addOtherConfig("url", ds.getUrl());
        tokenData.addOtherConfig("options", options);
        tokenData.addOtherConfig("hostType", ds.getType());
        tokenData.addOtherConfig(ds.getType(), true);
        return tokenData;
    }

    public void validate(DatasourceModel dsDef, List<DatasourceModel> datasources) {
        if (dsDef.getUrl().trim().isEmpty()) {
            throw new RuntimeException("INVALID_INSTANCE");
        }
        boolean alreadyExists = datasources.stream().anyMatch(ds -> ds.getName().equalsIgnoreCase(dsDef.getName()));
        if (alreadyExists) {
            throw new RuntimeException("CONFLICT");
        }
        try {
            DHConnector connector = this.connectorsFactory.getConnector(dsDef);
            if (!connector.isValid()) {
                throw new RuntimeException("INVALID_INSTANCE");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("INVALID_INSTANCE", e);
        }
    }
}

