/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.datasources.generators;

import com.roninpixels.dashboardhub.connectors.ConnectorsFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.datasources.generators.Generator;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.stereotype.Component;

@Component(value="AtlassianInsight")
public class AtlassianInsightRestDs
implements Generator {
    public static final String PRODUCT = "atlassian_insight";
    @Inject
    private Crypto mCrypto;
    @Inject
    private ConnectorsFactory connectorsFactory;

    @Override
    public boolean match(DatasourceModel def) {
        return PRODUCT.equals(def.getProduct());
    }

    @Override
    public DatasourceModel generateDS(DatasourceModel dsDef, List<DatasourceModel> datasources, DsOptionsModel options, Object req, Object res) throws Exception {
        String id = UUID.randomUUID().toString();
        DatasourceModel newDs = new DatasourceModel();
        newDs.setId(id);
        newDs.setName(dsDef.getName().trim());
        newDs.setUrl(dsDef.getUrl().trim());
        newDs.setType(this.getType(dsDef));
        newDs.setProduct(PRODUCT);
        newDs.setPrivate(dsDef.getPrivate());
        newDs.setCreator(dsDef.getCreator());
        newDs.setCreated(new Date());
        DsOptionsModel tokenData = this.generateDsOptions(newDs, options);
        ObjectMapper mapper = new ObjectMapper();
        String token = this.mCrypto.encryptBackend(mapper.writeValueAsString((Object)tokenData));
        newDs.setToken(token);
        this.validate(newDs, datasources);
        return newDs;
    }

    String getType(DatasourceModel ds) {
        String hostType;
        switch (hostType = ds.getOptions().getOption("hostType")) {
            case "self": {
                return "self";
            }
            case "datacenter": {
                return "datacenter";
            }
        }
        return "cloud";
    }

    DsOptionsModel generateDsOptions(DatasourceModel ds, DsOptionsModel options) {
        DsOptionsModel tokenData = new DsOptionsModel();
        tokenData.addOtherConfig("id", ds.getId());
        tokenData.addOtherConfig("name", ds.getName());
        tokenData.addOtherConfig("url", ds.getUrl());
        tokenData.addOtherConfig("product", ds.getProduct());
        tokenData.addOtherConfig("options", options);
        return tokenData;
    }

    public void validate(DatasourceModel dsDef, List<DatasourceModel> datasources) {
        if (dsDef.getUrl().trim().isEmpty()) {
            throw new RuntimeException("INVALID_INSTANCE");
        }
        boolean alreadyExists = datasources.stream().anyMatch(ds -> ds.getName().equalsIgnoreCase(dsDef.getName()));
        if (alreadyExists) {
            throw new RuntimeException("CONFLICT");
        }
        try {
            DHConnector connector = this.connectorsFactory.getConnector(dsDef);
            if (!connector.isValid()) {
                throw new RuntimeException("INVALID_INSTANCE");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("INVALID_INSTANCE", e);
        }
    }
}

