/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.roninpixels.dashboardhub.config.frontedModel.PerformanceSettingsModel;
import com.roninpixels.dashboardhub.controllers.PerformanceSettingsController;
import com.roninpixels.dashboardhub.exceptions.NotAuthorizedException;
import com.roninpixels.dashboardhub.services.DHUserService;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class PerformanceSettingsControllerImpl
implements PerformanceSettingsController {
    static final String PROP_NAME_REFRESH_TIME = "com.roninpixels.dashboardhub:performance.settings.refreshTime";
    @Inject
    @ComponentImport
    private PluginSettingsFactory pluginSettingsFactory;
    @Inject
    private DHUserService userService;

    @Override
    public void updatePerformanceSettings(PerformanceSettingsModel newSettings) {
        if (!this.userService.isLoggedUserAdmin().booleanValue()) {
            throw new NotAuthorizedException();
        }
        String refreshTime = newSettings.getRefreshTime();
        if (refreshTime == null) {
            return;
        }
        if (!REFRESH_TIME_ALLOWED.contains(refreshTime)) {
            throw new IllegalArgumentException("refreshTime value is not valid: " + refreshTime);
        }
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put(PROP_NAME_REFRESH_TIME, (Object)refreshTime);
    }

    @Override
    public PerformanceSettingsModel getPerformanceSettings() {
        PerformanceSettingsModel settings = new PerformanceSettingsModel();
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        Object refreshTime = pluginSettings.get(PROP_NAME_REFRESH_TIME);
        if (refreshTime != null) {
            settings.setRefreshTime(refreshTime.toString());
        }
        return settings;
    }
}

