/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.atlassian.activeobjects.tx.Transactional;
import com.roninpixels.dashboardhub.controllers.BoardPermissionsController;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.store.DHPermissionsRepository;
import com.roninpixels.dashboardhub.utils.permissions.RestrictionsUtil;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.PermissionModel;
import com.roninpixels.dashboardhub.web.models.RestrictionsModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class BoardPermissionsControllerImpl
implements BoardPermissionsController {
    @Autowired
    private DHPermissionsRepository permissionsRepo;
    @Inject
    private DHUserService userService;

    public static List<PermissionModel> getPermissionFrom(BoardModel board) {
        RestrictionsModel restrictions = board.getRestrictions();
        if (restrictions == null || restrictions.getUserGroups() == null) {
            return Collections.emptyList();
        }
        Map<String, List<String>> groupAndUsers = RestrictionsUtil.breakDownUserGroups(restrictions);
        return groupAndUsers.entrySet().parallelStream().flatMap(entry -> ((List)entry.getValue()).stream().map(holderId -> {
            String holderType = ((String)entry.getKey()).contains("user") ? "user" : "group";
            PermissionModel permission = new PermissionModel();
            permission.setHolderId((String)holderId);
            permission.setHolderType(holderType);
            permission.setPermission(100);
            permission.setTargetId(board.getId());
            permission.setTargetType("plugin");
            return permission;
        })).collect(Collectors.toList());
    }

    public List<String> getAccesibleBoardIds(String userKey, List<String> groups) {
        HashMap<String, List<String>> queryData = new HashMap<String, List<String>>();
        queryData.put("user", Arrays.asList(userKey));
        queryData.put("group", groups);
        List<PermissionModel> permissions = this.permissionsRepo.getPermissions((Integer)100, queryData);
        return permissions.stream().map(PermissionModel::getTargetId).distinct().collect(Collectors.toList());
    }

    @Override
    public List<String> getAccesibleBoardIdsForLoggedUser() {
        String userKey = this.userService.getLoggedInUserKey();
        if (userKey == null) {
            return Collections.emptyList();
        }
        ArrayList<String> groupNames = new ArrayList<String>(this.userService.getGroupNamesFor(userKey));
        return this.getAccesibleBoardIds(userKey, groupNames);
    }

    @Override
    public void updateBoardPermissions(BoardModel board) {
        this.removeBoardPermissions(board);
        List<PermissionModel> permissions = BoardPermissionsControllerImpl.getPermissionFrom(board);
        if (permissions.isEmpty()) {
            return;
        }
        this.permissionsRepo.createPermissions(permissions);
    }

    @Override
    public void removeBoardPermissions(BoardModel boardModel) {
        this.removeBoardPermissions(boardModel.getId());
    }

    @Override
    public void removeBoardPermissions(String boardId) {
        this.permissionsRepo.deletePermissions((Integer)100, boardId);
    }

    @Override
    public boolean isBoardVisibleFor(BoardModel board, String userKey) {
        boolean isPublicShared;
        boolean bl = isPublicShared = board.getSharing() != null && board.getSharing().getPublic() != false;
        if (userKey == null || isPublicShared) {
            return isPublicShared;
        }
        if (board.getGlobal().booleanValue() || board.getOwner().equals(userKey)) {
            return true;
        }
        List<String> accesibleBoardIds = this.getAccesibleBoardIdsForLoggedUser();
        return accesibleBoardIds.stream().anyMatch(id -> board.getId().equals(id));
    }
}

