/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.genericServer;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class RequestEnhancements {
    private static final int DEFAULT_MAX_RETRIES = 4;
    private static final Logger log = LoggerFactory.getLogger(RequestEnhancements.class);

    static <T> ResponseEntity<T> executeRetrying(Callable<ResponseEntity<T>> requestFunction) throws Exception {
        return RequestEnhancements.executeRetrying(requestFunction, 4);
    }

    static <T> ResponseEntity<T> executeRetrying(Callable<ResponseEntity<T>> requestFunction, int maxRetries) throws Exception {
        return RequestEnhancements.executeRetrying(requestFunction, maxRetries, 0);
    }

    private static <T> ResponseEntity<T> executeRetrying(Callable<ResponseEntity<T>> requestFunction, int maxRetries, int retryCount) throws Exception {
        ResponseEntity response = requestFunction.call();
        int status = response.getStatusCode().value();
        if (status == 429 || status >= 500 && status <= 599) {
            if (maxRetries > 0) {
                int delay;
                try {
                    delay = Integer.parseInt(response.getHeaders().getFirst("Retry-After"));
                }
                catch (Throwable e) {
                    delay = 2 * (int)Math.pow(2.0, retryCount);
                }
                int sleep = delay * 1000 + RequestEnhancements.jitter(delay * 500);
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    return response;
                }
                return RequestEnhancements.executeRetrying(requestFunction, --maxRetries, ++retryCount);
            }
            log.debug("MaxRetries exhausted after trying {} times.", (Object)retryCount);
            if (status == 429) {
                response = new ResponseEntity(response.getBody(), (MultiValueMap)response.getHeaders(), HttpStatus.SERVICE_UNAVAILABLE);
            }
        }
        return response;
    }

    private static int jitter(int addJitterMax) {
        int jitterMin = 700;
        int jitterMax = 1300 + addJitterMax;
        return (int)Math.floor(Math.random() * (double)(jitterMax - jitterMin)) + jitterMin;
    }
}

