/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter.functions;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public abstract class BitbucketDatacenterBaseFunc {
    private static final Logger log = LoggerFactory.getLogger(BitbucketDatacenterBaseFunc.class);
    protected final ServerConnector connector;

    public BitbucketDatacenterBaseFunc(ServerConnector serverConnector) {
        this.connector = serverConnector;
    }

    protected ServerConnector getConnector() {
        return this.connector;
    }

    public List getData(String path, Map<String, String> params, int elementsLimit, boolean loadAll) {
        HashMap<String, String> mParams = params != null ? new HashMap<String, String>(params) : new HashMap();
        mParams.putIfAbsent("limit", "50");
        mParams.putIfAbsent("start", "0");
        LinkedList elements = new LinkedList();
        boolean addMore = true;
        while (addMore) {
            ResponseEntity<Map> response = this.getConnector().executeRequest(path, mParams, Map.class);
            this.checkStatus(response);
            Map body = (Map)response.getBody();
            List values = (List)body.get("values");
            elements.addAll(values);
            boolean isLastPage = (Boolean)body.get("isLastPage");
            Integer nextPageStart = body.containsKey("nextPageStart") ? (Integer)body.get("nextPageStart") : null;
            addMore = loadAll && elements.size() < elementsLimit && !isLastPage && nextPageStart != null;
            if (!addMore) continue;
            mParams.put("start", "" + nextPageStart);
        }
        return elements;
    }

    public void checkStatus(ResponseEntity response) {
        int responseCode = response.getStatusCode().value();
        if (responseCode >= 400) {
            throw new BadRequestToSourceException(response);
        }
    }
}

