/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.authStrategy.strategies;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.StrategyWithHeaders;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.http.HttpHeaders;
import org.springframework.web.util.UriComponentsBuilder;

public class DatasourceBasicAuthStrategy
extends StrategyWithHeaders {
    public static final String P_USER = "username";
    public static final String P_PASS = "password";
    @Inject
    private Crypto mCrypto;
    private final DatasourceModel datasource;
    private final ObjectMapper mapper;

    public DatasourceBasicAuthStrategy(DatasourceModel datasource) {
        this.datasource = datasource;
        this.mapper = new ObjectMapper();
    }

    @Override
    public Request applyAuthenticationStrategy(Request request, UriComponentsBuilder builder) {
        String pass;
        super.applyAuthenticationStrategy(request, builder);
        DsOptionsModel dsOptions = this.getOptions(this.datasource.getToken());
        Map options = dsOptions.getOption("options", Map.class);
        String user = options != null ? (String)options.get(P_USER) : null;
        String string = pass = options != null ? (String)options.get(P_PASS) : null;
        if (user != null && pass != null) {
            return request.addBasicAuthentication(builder.build().getHost(), user, pass);
        }
        throw new RuntimeException("Credentials not defined");
    }

    public HttpHeaders createHeaders() {
        DsOptionsModel dsOptions = this.getOptions(this.datasource.getToken());
        Map options = dsOptions.getOption("options", Map.class);
        final String user = options != null ? (String)options.get(P_USER) : null;
        final String pass = options != null ? (String)options.get(P_PASS) : null;
        return new HttpHeaders(){
            {
                String auth = user + ":" + pass;
                byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(Charset.forName("US-ASCII")));
                String authHeader = "Basic " + new String(encodedAuth);
                this.set("Authorization", authHeader);
            }
        };
    }

    private DsOptionsModel getOptions(String token) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (DsOptionsModel)mapper.readValue(this.mCrypto.decryptBackend(token), DsOptionsModel.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

