/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.authStrategy.strategies;

import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.web.util.UriComponentsBuilder;

public class BearerTokenAuthStrategy
implements RestAuthStrategy {
    private final String P_TOKEN = "token";
    private final DatasourceModel datasource;
    private final ObjectMapper mapper;
    @Inject
    private Crypto mCrypto;

    public BearerTokenAuthStrategy(DatasourceModel datasource) {
        this.datasource = datasource;
        this.mapper = new ObjectMapper();
    }

    @Override
    public Request applyAuthenticationStrategy(Request request, UriComponentsBuilder builder) {
        String apiToken;
        DsOptionsModel dsOptions = this.getOptions(this.datasource.getToken());
        Map options = dsOptions.getOption("options", Map.class);
        String string = apiToken = options != null ? (String)options.get("token") : null;
        if (apiToken != null) {
            String authValue = String.format("Bearer %s", apiToken);
            return request.addHeader("Authorization", authValue);
        }
        throw new RuntimeException("Bearer Token not defined");
    }

    private DsOptionsModel getOptions(String token) {
        try {
            return (DsOptionsModel)this.mapper.readValue(this.mCrypto.decryptBackend(token), DsOptionsModel.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void analyzeHeaders(Response response) {
    }
}

