/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.config.action;

import com.roninpixels.dashboardhub.config.DashboardHubConfig;
import com.roninpixels.dashboardhub.config.FrontendConfigurationService;
import com.roninpixels.dashboardhub.config.action.DHAction;
import com.roninpixels.dashboardhub.config.frontedModel.AppConfigModel;
import com.roninpixels.dashboardhub.config.frontedModel.FrontendConfigModel;
import com.roninpixels.dashboardhub.controllers.AccessManagementController;
import com.roninpixels.dashboardhub.controllers.BoardsController;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import java.io.IOException;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHShowAction
implements DHAction {
    private static final Logger log = LoggerFactory.getLogger(DHShowAction.class);
    @Inject
    private FrontendConfigurationService configService;
    @Inject
    private DashboardHubConfig dashboardHubConfig;
    @Inject
    private BoardsController boardsController;
    @Inject
    private AccessManagementController accessManagementController;
    private TokenContentModel tokenData;

    @Override
    public void setToken(TokenContentModel tokenContent) {
        this.tokenData = tokenContent;
    }

    @Override
    public DashboardHubConfig getDashboardHubConfig() {
        return this.dashboardHubConfig;
    }

    @Override
    public String getConfig() {
        try {
            FrontendConfigModel config = this.configService.createConfig();
            if (this.tokenData != null) {
                config.setWallboard(this.getSerializedBoard());
                if (config.getWallboard() == null) {
                    config.setDhError("FORBIDDEN");
                }
                config.setSharedBoard(config.getWallboard());
            }
            return this.configService.serializeConfig(config);
        }
        catch (IOException e) {
            log.error("Problems with configuration injection", (Throwable)e);
            return "ERROR";
        }
    }

    private String getSerializedBoard() {
        if (this.tokenData != null) {
            try {
                BoardModel board = this.boardsController.getUserBoard(this.tokenData.getUsserAccountId(), this.tokenData.getBoardId(), this.tokenData.getGlobal());
                if (this.boardsController.checkUserLoggedCanView(board)) {
                    ObjectMapper mapper = new ObjectMapper();
                    String json = mapper.writeValueAsString((Object)board);
                    return json;
                }
            }
            catch (Exception e) {
                log.error("Problems getting a board for internal sharing -> " + this.tokenData.getBoardId(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String getAppConfig() {
        AppConfigModel appConfig = this.accessManagementController.getConfig(true);
        try {
            return this.configService.serializeConfig(appConfig);
        }
        catch (IOException e) {
            log.error("Problems with configuration injection", (Throwable)e);
            return "ERROR";
        }
    }
}

