/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.config;

import com.roninpixels.dashboardhub.config.frontedModel.DashboardHub;
import com.roninpixels.dashboardhub.config.frontedModel.FrontendConfigModel;
import com.roninpixels.dashboardhub.config.frontedModel.InstanceInfo;
import com.roninpixels.dashboardhub.config.frontedModel.SessionData;
import com.roninpixels.dashboardhub.config.frontedModel.User;
import com.roninpixels.dashboardhub.config.interfaces.DHAccessModeService;
import com.roninpixels.dashboardhub.controllers.AccessManagementController;
import com.roninpixels.dashboardhub.license.LicenseStatusJsonBean;
import com.roninpixels.dashboardhub.services.ApplicationPropertiesAccesor;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.DashboardHubPluginManager;
import com.roninpixels.dashboardhub.services.model.AppUser;
import java.io.IOException;
import java.util.Base64;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class FrontendConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(FrontendConfigurationService.class);
    @Inject
    private DashboardHubPluginManager dhLicenseManager;
    @Inject
    private ApplicationPropertiesAccesor applicationProperties;
    @Inject
    private DHUserService authenticatedUserService;
    @Inject
    private DHAccessModeService accessModeService;
    @Inject
    private AccessManagementController accessManagementController;
    private String product;

    @PostConstruct
    public void init() {
        this.product = this.applicationProperties.getApplicationName();
    }

    public FrontendConfigModel createConfig() {
        String baseURL = this.applicationProperties.getAppProperty("baseURL", null);
        AppUser appUser = this.authenticatedUserService.getLoggedInUser();
        FrontendConfigModel config = new FrontendConfigModel();
        config.setDashboardHub(this.getDashboardHub(baseURL));
        LicenseStatusJsonBean licenseStatus = this.dhLicenseManager.getLicenseStatus();
        config.setLicense(licenseStatus);
        config.setInstanceInfo(this.getInstanceInfo(licenseStatus, baseURL));
        config.setSessionData(this.getSessionData(appUser, baseURL));
        config.setJsdPortal("https://roninpixels.atlassian.net/servicedesk/customer/portal/7");
        config.setExternal(false);
        return config;
    }

    public String serializeConfig(Object config) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString(config);
        return Base64.getEncoder().encodeToString(json.getBytes());
    }

    private SessionData getSessionData(AppUser appUser, String baseURL) {
        SessionData sessionData = new SessionData();
        sessionData.setHost(baseURL);
        sessionData.setThreeLo(false);
        sessionData.setAdmin(this.authenticatedUserService.isLoggedUserAdmin());
        sessionData.setUser(this.getUser(appUser));
        if (appUser != null) {
            sessionData.setLocale(appUser.getLocale().toString());
        } else {
            sessionData.setLocale(this.applicationProperties.getDefaultLocale().toString());
        }
        return sessionData;
    }

    private InstanceInfo getInstanceInfo(LicenseStatusJsonBean licenseStatus, String baseURL) {
        InstanceInfo instanceInfo = new InstanceInfo();
        instanceInfo.setAddonKey(licenseStatus.getKey());
        instanceInfo.setAddonPath(baseURL);
        instanceInfo.setInstance(baseURL);
        instanceInfo.setLite(false);
        instanceInfo.setLicensed(licenseStatus.isValid());
        instanceInfo.setProduct(this.product);
        instanceInfo.setVersion(this.dhLicenseManager.getPluginVersion());
        instanceInfo.setCustomerPortalEnabled(this.accessManagementController.isCustomerPortalEnabled());
        instanceInfo.setJsmLicensedForUse(this.accessManagementController.isJsmLicensedForUse());
        return instanceInfo;
    }

    private DashboardHub getDashboardHub(String baseURL) {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)baseURL).build();
        DashboardHub dh = new DashboardHub();
        dh.setHosting("server");
        dh.setBaseURL(baseURL);
        dh.setContextPath(uriComponents.getPath() == null ? "" : uriComponents.getPath());
        dh.setApiPath("rest/dashboardhub/1.0");
        dh.setProduct(this.product);
        dh.setProxyPath("/rest/proxy/1.0/resource");
        dh.setInternalSharedDashboardPath(this.applicationProperties.getInternalSharedDashboardPath());
        dh.setSharedDashboardPath(this.applicationProperties.getSharedDashboardPath());
        dh.setReadOnly(this.accessModeService.isReadOnlyAccessModeEnabled());
        return dh;
    }

    private User getUser(AppUser appUser) {
        User user = new User();
        if (appUser != null) {
            user.setAccountId(appUser.getKey());
        }
        return user;
    }
}

