/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.jira.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.web.rest.jira.api.JQLEndpoint;
import com.roninpixels.dashboardhub.web.rest.jira.api.SearchEpicsRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/jira/v1/searchEpics")
public class SearchEpicsEndpoint {
    private static final Logger log = LoggerFactory.getLogger(JQLEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    List<Map> searchEpics(JiraConnector jira, String searchTerm, List<String> epicFields) {
        String jql = "issueType = epic";
        if (searchTerm != null && !searchTerm.isEmpty()) {
            jql = String.format("%s AND (\"Epic Name\" ~ \"%s\" OR summary ~ \"%s\")", jql, searchTerm, searchTerm);
        }
        ArrayList<String> fields = new ArrayList<String>(epicFields);
        fields.add("summary");
        HashMap<String, Object> extraOpts = new HashMap<String, Object>();
        extraOpts.put("loadAll", false);
        extraOpts.put("maxResults", 15);
        return jira.execJQL(jql, fields, null, null, extraOpts, null);
    }

    @POST
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response search(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @NotNull SearchEpicsRequest request) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            List<Map> epics = this.searchEpics(jira, request.getSearchTerm(), request.getEpicFieldKeys());
            return Response.status((int)200).entity(epics).build();
        }
        catch (Exception e) {
            log.error("Problems getting epics suggestions", (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

