/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.license.rulesImpl;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.roninpixels.dashboardhub.license.DHLicenseRule;
import com.roninpixels.dashboardhub.license.LicenseStatusJsonBean;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class DefaultDHLicenseRule
implements DHLicenseRule {
    @Inject
    @ComponentImport
    private PluginLicenseManager licenseManager;

    @Override
    public boolean isLicensed() {
        LicenseStatusJsonBean bean = this.getLicenseStatus();
        return bean != null && bean.isValid();
    }

    @Override
    public LicenseStatusJsonBean getLicenseStatus() {
        LicenseStatusJsonBean bean;
        if (this.licenseManager.getLicense().isDefined()) {
            bean = LicenseStatusJsonBean.shortBean((PluginLicense)this.licenseManager.getLicense().get());
            bean.setValid(bean.isValid());
        } else {
            bean = this.getDataForNoPresentLicense();
        }
        return bean;
    }

    private LicenseStatusJsonBean getDataForNoPresentLicense() {
        String key = this.licenseManager.getPluginKey();
        LicenseStatusJsonBean bean = new LicenseStatusJsonBean();
        bean.setValid(false);
        bean.setKey(key);
        return bean;
    }
}

