/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.permissions;

import com.roninpixels.dashboardhub.permissions.BoardPermissionRule;
import com.roninpixels.dashboardhub.permissions.EditPermission;
import com.roninpixels.dashboardhub.permissions.ViewPermission;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.stereotype.Service;

@Service
public class BoardAccessManager {
    @Inject
    private List<ViewPermission> viewRules;
    @Inject
    List<EditPermission> editRules;

    private boolean match(BoardModel board, BoardPermissionRule permissionRule) {
        String type = board.getRestrictions() != null ? board.getRestrictions().getType() : null;
        return type == null || type.equals(permissionRule.getClass().getAnnotation(Named.class).value());
    }

    public boolean canUserLoggedInView(BoardModel board) {
        return this.viewRules.stream().filter(rule -> this.match(board, (BoardPermissionRule)rule)).allMatch(rule -> rule.evaluateView(board));
    }

    public boolean canUserLoggedInEdit(BoardModel board) {
        return this.editRules.stream().filter(rule -> this.match(board, (BoardPermissionRule)rule)).allMatch(rule -> rule.evaluateEdit(board));
    }
}

