/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.statusPage;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.statusPage.StatusPageGadgetRequesterBase;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class ServiceStatus
extends StatusPageGadgetRequesterBase {
    private static final Logger log = LoggerFactory.getLogger(ServiceStatus.class);

    List getPageComponents(String pageId) throws Exception {
        ResponseEntity<String> resp = this.statusPageConnector.getPageComponents(pageId, Collections.emptyMap());
        return this.checkStatusAndParse(resp, List.class);
    }

    List getNotResolvedPageIncidents(String pageId) throws Exception {
        ResponseEntity<String> resp = this.statusPageConnector.getPageIncidents(pageId, Collections.emptyMap());
        List incidents = this.checkStatusAndParse(resp, List.class);
        List resolvedIncidents = incidents.stream().filter(incident -> !"resolved".equals(incident.get("status"))).collect(Collectors.toList());
        return resolvedIncidents;
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        String pageId = (String)gadget.getConfig().getOtherConfig().get("page");
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("pageInfo", this.getPage(pageId));
            data.put("components", this.getPageComponents(pageId));
            data.put("incidents", this.getNotResolvedPageIncidents(pageId));
            return data;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            log.error("Something went wrong", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

