/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.JSMBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.JSMDataUtil2;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.configs.TeamQueueConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JqlUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamQueue
extends JSMBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(TeamQueue.class);

    protected Map getQueueAndIssues(TeamQueueConfig config) throws Exception {
        LinkedHashMap<String, Object> queueIssuesMap = new LinkedHashMap<String, Object>();
        TeamQueueConfig jqlFilterConfig = config;
        String jql = null;
        List fields = null;
        Map<String, List<String>> queue = new LinkedHashMap();
        if (jqlFilterConfig.getUseJQL() != null && jqlFilterConfig.getUseJQL().booleanValue()) {
            jql = jqlFilterConfig.getJql();
            fields = config.getFields();
            queue.put("fields", config.getFields());
        } else {
            queue = this.getQueue(config.getProject(), config.getQueue());
            jql = queue.get("jql").toString();
            fields = (List)queue.get("fields");
        }
        String orderBy = "";
        LinkedList<String> clauses = new LinkedList<String>();
        if (config.getTimeRange() != null) {
            String dateFrom = JSMDataUtil2.getDateAsString(config.getTimeRange());
            clauses.add(String.format("updatedDate >= '%s'", dateFrom));
        }
        if (jql != null && !jql.trim().isEmpty()) {
            String[] jqlBreakdown = JqlUtils.getJQLandOrderBy(jql);
            clauses.add(String.format("(%s)", jqlBreakdown[0]));
            orderBy = jqlBreakdown[1];
        }
        String finalJQL = clauses.stream().collect(Collectors.joining(" AND "));
        if (!orderBy.isEmpty()) {
            finalJQL = String.format("%s %s", finalJQL, orderBy);
        }
        List issues = this.execJQLwithFilterFields(finalJQL, fields, null, null, null, null);
        queueIssuesMap.put("queue", queue);
        queueIssuesMap.put("issues", issues);
        return queueIssuesMap;
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        TeamQueueConfig config = GadgetRequesterUtils.getConfig(gadget, TeamQueueConfig.class);
        try {
            Map queueIssuesMap = this.getQueueAndIssues(config);
            HashMap data = new HashMap();
            data.put("issues", queueIssuesMap.get("issues"));
            data.put("queue", queueIssuesMap.get("queue"));
            return data;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems getting data", e);
        }
    }
}

