/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.store.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.roninpixels.dashboardhub.ao.AddonProperty;
import com.roninpixels.dashboardhub.store.AddonPropertiesRepository;
import javax.inject.Inject;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AddonPropertiesRepositoryImp
implements AddonPropertiesRepository {
    private static final Logger log = LoggerFactory.getLogger(AddonPropertiesRepositoryImp.class);
    @ComponentImport
    private final ActiveObjects ao;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;

    @Inject
    public AddonPropertiesRepositoryImp(ActiveObjects ao, TransactionTemplate transactionTemplate) {
        this.ao = ao;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public AddonProperty create(String key, String value) {
        return (AddonProperty)this.transactionTemplate.execute(() -> {
            AddonProperty property = (AddonProperty)this.ao.create(AddonProperty.class, new DBParam[]{new DBParam("KEY", (Object)key), new DBParam("VALUE", (Object)value)});
            property.setKey(key);
            property.setValue(value);
            property.save();
            log.debug("Addon property saved -> " + key);
            return property;
        });
    }

    @Override
    public AddonProperty get(String key) {
        AddonProperty[] props = (AddonProperty[])this.ao.find(AddonProperty.class, "KEY = ?", new Object[]{key});
        log.debug("Addon properties found -> " + (props != null ? Integer.valueOf(props.length) : props));
        return props != null && props.length > 0 ? props[0] : null;
    }

    @Override
    public AddonProperty update(String key, String newValue) {
        return (AddonProperty)this.transactionTemplate.execute(() -> {
            AddonProperty property = this.get(key);
            if (property != null) {
                property.setValue(newValue);
                property.save();
            }
            return property;
        });
    }

    @Override
    public AddonProperty remove(String key) {
        return (AddonProperty)this.transactionTemplate.execute(() -> {
            AddonProperty property = this.get(key);
            if (property != null) {
                this.ao.delete(new RawEntity[]{property});
            }
            return property;
        });
    }
}

