/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JqlUtils {
    private static final Logger log = LoggerFactory.getLogger(JqlUtils.class);

    public static final boolean startsWithOrderBy(String query) {
        query = query == null ? "" : query;
        return query.trim().toUpperCase().startsWith("ORDER BY");
    }

    public static final String appendToJql(String jql, String prefix, String joinKeyword) {
        joinKeyword = jql == null || jql.trim().equals("") ? "" : (joinKeyword == null || joinKeyword.trim().equals("") ? "AND" : joinKeyword);
        prefix = prefix == null ? "" : prefix;
        String separator = JqlUtils.startsWithOrderBy(jql) ? " " : String.format(" %s ", joinKeyword);
        return (prefix + separator + jql).trim();
    }

    public static final String appendContextFilterToJql(String jql, Map context) {
        boolean applyContentFiltering;
        String contentFilteringJQL = "";
        if (context.containsKey("applyContentFiltering") && (applyContentFiltering = ((Boolean)context.get("applyContentFiltering")).booleanValue())) {
            contentFilteringJQL = (String)context.get("contentFilteringJQL");
        }
        if (contentFilteringJQL.trim().equals("")) {
            return jql;
        }
        if (jql.trim().equals("")) {
            return contentFilteringJQL;
        }
        String[] jqlAndOrderBy = JqlUtils.getJQLandOrderBy(jql);
        StringBuilder jqlFixed = new StringBuilder();
        jqlFixed.append("(").append(jqlAndOrderBy[0]).append(")");
        return String.format("%s %s", JqlUtils.appendToJql(jqlFixed.toString(), contentFilteringJQL, "AND"), jqlAndOrderBy[1]);
    }

    public static final String[] getJQLandOrderBy(String jql) {
        String[] result = jql.split("(?i)order by");
        if (result.length > 1) {
            result[1] = "ORDER BY" + result[1];
        } else {
            result = new String[]{result[0], ""};
        }
        return result;
    }

    public static final String getJQLwithoutOrderBy(String jql) {
        return jql.split("(?i)order by")[0];
    }
}

