/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.confluenceServer.functions;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class ExecCQLFunc {
    private static final Logger log = LoggerFactory.getLogger(ExecCQLFunc.class);
    private final ServerConnector connector;

    public ExecCQLFunc(ServerConnector connector) {
        this.connector = connector;
    }

    private String getURLNext(Map response) {
        try {
            if (!response.containsKey("_links")) {
                return null;
            }
            Map links = (Map)response.get("_links");
            String urlNext = (String)links.get("next");
            return urlNext == null ? null : URLDecoder.decode(urlNext, StandardCharsets.UTF_8.name());
        }
        catch (IOException ioe) {
            log.warn("Problems decoding an URL", (Throwable)ioe);
            return null;
        }
    }

    public List execCQL(Map params, Map<String, Object> options) {
        ResponseEntity<Map> responseEntity;
        HashMap<String, Object> mParams;
        boolean all = (Boolean)options.getOrDefault("all", false);
        int start = params.getOrDefault("start", 0);
        int limit = params.getOrDefault("limit", 1000);
        String url = null;
        if (options.containsKey("url")) {
            url = (String)options.get("url");
            mParams = new HashMap();
        } else {
            mParams = new HashMap<String, Object>(params);
        }
        if (options.containsKey("expand")) {
            mParams.put("expand", options.get("expand"));
        }
        if (params.get("cql") == null) {
            mParams.put("cql", "");
        }
        if ((responseEntity = this.connector.executeRequest(url != null ? url : "/rest/api/content/search", mParams, Map.class)).getStatusCode().value() < 400) {
            Map response = (Map)responseEntity.getBody();
            LinkedList data = (LinkedList)response.get("results");
            start = (Integer)response.get("start");
            limit = (Integer)response.get("limit");
            int next = start + limit;
            String nextURL = this.getURLNext(response);
            if (all && next < 1000 && nextURL != null) {
                mParams.put("start", start + limit);
                mParams.put("limit", limit);
                HashMap<String, Object> newOptions = new HashMap<String, Object>(options);
                newOptions.put("url", nextURL);
                List moreData = this.execCQL(mParams, newOptions);
                data = new LinkedList(data);
                data.addAll(moreData);
                return data;
            }
            return data;
        }
        log.error("Problems with cql request: " + responseEntity);
        return Collections.emptyList();
    }
}

