/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.store.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Preconditions;
import com.roninpixels.dashboardhub.ao.DHDashboardGadget;
import com.roninpixels.dashboardhub.controllers.GadgetTokenController;
import com.roninpixels.dashboardhub.store.DHDashboardGadgetsRepository;
import com.roninpixels.dashboardhub.web.models.EncryptedDashboardGadgetModel;
import java.io.IOException;
import javax.inject.Inject;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DHDashboardGadgetsRepositoryImpl
implements DHDashboardGadgetsRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DHDashboardGadgetsRepositoryImpl.class);
    @ComponentImport
    private final ActiveObjects ao;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @Inject
    private GadgetTokenController gadgetTokenController;
    private final ObjectMapper mMapper;

    @Inject
    public DHDashboardGadgetsRepositoryImpl(ActiveObjects ao, TransactionTemplate transactionTemplate) {
        this.ao = (ActiveObjects)Preconditions.checkNotNull((Object)ao);
        this.transactionTemplate = transactionTemplate;
        this.mMapper = new ObjectMapper();
    }

    @Override
    public EncryptedDashboardGadgetModel getDashboardGadget(String containerId, String itemId) {
        DHDashboardGadget dashboardGadget = this.findDashboardGadget(containerId, itemId);
        return dashboardGadget != null ? this.transform(dashboardGadget) : null;
    }

    @Override
    public EncryptedDashboardGadgetModel addDashboardGadget(EncryptedDashboardGadgetModel newDashboardGadget) throws IOException {
        EncryptedDashboardGadgetModel existingDashboardGadget = this.getDashboardGadget(newDashboardGadget.getContainerId(), newDashboardGadget.getItemId());
        if (existingDashboardGadget != null) {
            throw new RuntimeException("Dashboard gadget already exists");
        }
        String value = this.mMapper.writeValueAsString((Object)newDashboardGadget);
        DHDashboardGadget savedDashboardGadget = (DHDashboardGadget)this.transactionTemplate.execute(() -> {
            DHDashboardGadget dashboardGadget = (DHDashboardGadget)this.ao.create(DHDashboardGadget.class, new DBParam[]{new DBParam("CONTAINER_ID", (Object)newDashboardGadget.getContainerId()), new DBParam("ITEM_ID", (Object)newDashboardGadget.getItemId()), new DBParam("OWNER", (Object)newDashboardGadget.getOwner()), new DBParam("VALUE", (Object)value)});
            dashboardGadget.save();
            LOGGER.debug(String.format("Dashboard Gadget created! containerId: %s, itemId: %s", dashboardGadget.getContainerId(), dashboardGadget.getItemId()));
            return dashboardGadget;
        });
        return this.transform(savedDashboardGadget);
    }

    @Override
    public EncryptedDashboardGadgetModel updateDashboardGadget(EncryptedDashboardGadgetModel dashboardGadget) throws IOException {
        String value = this.mMapper.writeValueAsString((Object)dashboardGadget);
        DHDashboardGadget updatedDashboardGadget = (DHDashboardGadget)this.transactionTemplate.execute(() -> {
            DHDashboardGadget target = this.findDashboardGadget(dashboardGadget.getContainerId(), dashboardGadget.getItemId());
            if (target != null) {
                target.setValue(value);
                target.setOwner(dashboardGadget.getOwner());
                target.save();
                LOGGER.debug(String.format("Dashboard Gadget updated! containerId: %s, itemId: %s", dashboardGadget.getContainerId(), dashboardGadget.getItemId()));
            }
            return target;
        });
        return updatedDashboardGadget != null ? this.transform(updatedDashboardGadget) : null;
    }

    @Override
    public boolean removeDashboardGadget(String containerId, String itemId) {
        if (containerId == null || itemId == null) {
            throw new IllegalArgumentException("containerId, itemId cannot be null");
        }
        DHDashboardGadget deletedDashboardGadget = (DHDashboardGadget)this.transactionTemplate.execute(() -> {
            DHDashboardGadget targetDashboardGadget = this.findDashboardGadget(containerId, itemId);
            if (targetDashboardGadget != null) {
                this.ao.delete(new RawEntity[]{targetDashboardGadget});
            }
            return targetDashboardGadget;
        });
        return deletedDashboardGadget != null;
    }

    @Override
    public EncryptedDashboardGadgetModel addDashboardGadget(EncryptedDashboardGadgetModel newDashboardGadget, boolean idAsItemId) throws IOException {
        if (!idAsItemId) {
            return this.addDashboardGadget(newDashboardGadget);
        }
        String value = this.mMapper.writeValueAsString((Object)newDashboardGadget);
        DHDashboardGadget savedDashboardGadget = (DHDashboardGadget)this.transactionTemplate.execute(() -> {
            DHDashboardGadget dashboardGadget = (DHDashboardGadget)this.ao.create(DHDashboardGadget.class, new DBParam[]{new DBParam("CONTAINER_ID", (Object)newDashboardGadget.getContainerId()), new DBParam("ITEM_ID", (Object)newDashboardGadget.getItemId()), new DBParam("OWNER", (Object)newDashboardGadget.getOwner()), new DBParam("VALUE", (Object)value)});
            dashboardGadget.save();
            LOGGER.debug(String.format("Dashboard Gadget created! containerId: %s, itemId: %s", dashboardGadget.getContainerId(), dashboardGadget.getItemId()));
            dashboardGadget.setItemId(String.valueOf(dashboardGadget.getID()));
            EncryptedDashboardGadgetModel encryptedUpdated = this.transform(dashboardGadget);
            encryptedUpdated.setItemId(String.valueOf(dashboardGadget.getID()));
            try {
                String valueUpdated = this.mMapper.writeValueAsString((Object)encryptedUpdated);
                dashboardGadget.setValue(valueUpdated);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            dashboardGadget.save();
            return dashboardGadget;
        });
        return this.transform(savedDashboardGadget);
    }

    private DHDashboardGadget findDashboardGadget(String containerId, String itemId) {
        Query query = Query.select().where("CONTAINER_ID = ? AND ITEM_ID = ?", new Object[]{containerId, itemId});
        DHDashboardGadget[] dashboardGadgets = (DHDashboardGadget[])this.ao.find(DHDashboardGadget.class, query);
        if (dashboardGadgets.length == 0) {
            return null;
        }
        if (dashboardGadgets.length > 1) {
            throw new RuntimeException(String.format("There are more than one dashboard gadget with same containerId: %s, itemId: %s", containerId, itemId));
        }
        return dashboardGadgets[0];
    }

    private EncryptedDashboardGadgetModel transform(DHDashboardGadget dashboardGadget) {
        try {
            EncryptedDashboardGadgetModel encryptedDashboardGadgetModel = (EncryptedDashboardGadgetModel)this.mMapper.readValue(dashboardGadget.getValue(), EncryptedDashboardGadgetModel.class);
            return encryptedDashboardGadgetModel;
        }
        catch (IOException ioe) {
            LOGGER.warn(String.format("Stored dashboard gadget invalid!!! containerId: %s, itemId: %s", dashboardGadget.getContainerId(), dashboardGadget.getItemId()));
            return null;
        }
    }
}

