/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.license;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.roninpixels.dashboardhub.license.DHLicenseRule;
import com.roninpixels.dashboardhub.license.LicenseInfoJsonBean;
import com.roninpixels.dashboardhub.license.LicenseStatusJsonBean;
import com.roninpixels.dashboardhub.license.rulesImpl.DefaultDHLicenseRule;
import com.roninpixels.dashboardhub.services.ApplicationPropertiesAccesor;
import com.roninpixels.dashboardhub.services.DashboardHubPluginManager;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DashboardHubPluginManagerImpl
implements DashboardHubPluginManager {
    private static final Logger log = LoggerFactory.getLogger(DashboardHubPluginManagerImpl.class);
    @ComponentImport
    private final PluginLicenseManager licenseManager;
    @ComponentImport
    private final PluginAccessor pluginAccessor;
    @Inject
    private ApplicationPropertiesAccesor applicationProperties;
    @Inject
    private List<DHLicenseRule> licenseRules;
    @Inject
    private DefaultDHLicenseRule defaultRule;

    @Inject
    public DashboardHubPluginManagerImpl(PluginAccessor pluginAccessor, PluginLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
        this.pluginAccessor = pluginAccessor;
    }

    private DHLicenseRule getFirstValidRule() {
        return this.licenseRules.stream().filter(DHLicenseRule::isLicensed).findFirst().orElse(this.defaultRule);
    }

    @Override
    public boolean isLicensed() {
        DHLicenseRule rule = this.getFirstValidRule();
        LicenseStatusJsonBean bean = rule.getLicenseStatus();
        return bean != null && bean.isValid();
    }

    @Override
    public LicenseStatusJsonBean getLicenseStatus() {
        DHLicenseRule rule = this.getFirstValidRule();
        return rule.getLicenseStatus();
    }

    @Override
    public String getPluginVersion() {
        String key = this.licenseManager.getPluginKey();
        return this.pluginAccessor.getEnabledPlugin(key).getPluginInformation().getVersion();
    }

    @Override
    public String getDataService() {
        return "lfdzB5ajxaS".replaceAll("a", "e");
    }

    @Override
    public LicenseInfoJsonBean getLicenseDetails(String pluginKey) {
        if (!this.licenseManager.getPluginKey().equals(pluginKey)) {
            return null;
        }
        PluginLicense pl = this.licenseManager.getLicense().isDefined() ? (PluginLicense)this.licenseManager.getLicense().get() : null;
        return LicenseInfoJsonBean.shortBean(this.pluginAccessor.getPlugin(pluginKey), pl, this.applicationProperties.getDisplayName());
    }
}

