/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.opsgenie;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.opsgenie.OpsgenieGadgetRequesterBase;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class LastIncidents
extends OpsgenieGadgetRequesterBase {
    private static final Logger log = LoggerFactory.getLogger(LastIncidents.class);

    List getIncidents() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("query", "status: open");
        params.put("limit", "3");
        params.put("sort", "updatedAt");
        params.put("order", "desc");
        ResponseEntity<List> resp = this.connector.getIncidents(params);
        this.checkStatus(resp);
        return (List)resp.getBody();
    }

    List getTeams() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("loadAll", "true");
        ResponseEntity<List> resp = this.connector.listTeams(params);
        this.checkStatus(resp);
        return (List)resp.getBody();
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        try {
            HashMap<String, List> data = new HashMap<String, List>();
            data.put("incidents", this.getIncidents());
            if (Boolean.parseBoolean(extraParams.get(0))) {
                data.put("teams", this.getTeams());
            }
            return data;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            log.error("Something went wrong", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

