"use strict";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

(function () {
  var IMAGE_WIDTH = 1056;
  var IMAGE_HEIGHT = 562;
  var MACRO_DASHBOARD_NAME = 'dashboardhub';
  var MACRO_GADGET_NAME = 'dashboardhubgadget';
  var URL_BASE = window.location.origin + AJS.contextPath();
  var dhLib = {};

  var hideEditorFrame = function hideEditorFrame() {
    dhLib.macroTarget = undefined;
    dhLib.editorFrame.remove();
  };

  var saveCurrentMacro = function saveCurrentMacro(params) {
    var macroParams = dhLib.getTargetMacroParams();
    var macroRenderRequest = {
      contentId: Confluence.Editor.getContentId(),
      macro: {
        name: params.gadgetId ? MACRO_GADGET_NAME : MACRO_DASHBOARD_NAME,
        params: _objectSpread({}, macroParams, {}, params, {
          containerId: Confluence.Editor.getContentId()
        }),
        defaultParameterValue: "",
        body: ""
      }
    };
    return tinymce.confluence.MacroUtils.insertMacro(macroRenderRequest);
  };

  dhLib.hideEditorFrame = hideEditorFrame;

  dhLib.getTargetMacroParams = function () {
    return dhLib.targetMacroParams;
  };

  dhLib.saveCurrentMacro = saveCurrentMacro;
  window.dhLib = dhLib;

  var getMacroParams = function getMacroParams(macroNode) {
    var currentParams = Confluence.MacroParameterSerializer.deserialize($(macroNode).attr("data-macro-parameters"));
    return currentParams;
  };

  var dhEdit = function dhEdit(e, macroNode) {
    var macroSettings = _objectSpread({
      boardId: ''
    }, getMacroParams(macroNode));

    window.dhLib.targetMacroParams = macroSettings;
    var newIframe = dhSoy.macro.editBoard({
      settings: macroSettings
    });
    var editorFrame = $("".concat(newIframe));
    editorFrame.appendTo('body');
    window.dhLib.editorFrame = editorFrame;
  };

  var dhEditGadget = function dhEditGadget(e, macroNode) {
    var macroSettings = _objectSpread({
      gadgetId: 0,
      containerId: Confluence.Editor.getContentId()
    }, getMacroParams(macroNode));

    window.dhLib.targetMacroParams = macroSettings;
    window.containerData = {
      containerId: macroSettings.containerId,
      itemId: macroSettings.gadgetId,
      macro: true
    };
    var newIframe = dhSoy.macro.editGadget({
      settings: macroSettings
    });
    var editorFrame = $("".concat(newIframe));
    editorFrame.appendTo('body');
    window.dhLib.editorFrame = editorFrame;
  };

  var dhEditMacro = function dhEditMacro(macroNode) {
    var macroParams = macroNode.params || getMacroParams(macroNode);
    var macroName = macroNode.name || macroNode.getAttribute('data-macro-name');

    if (macroName === MACRO_DASHBOARD_NAME && !macroParams.boardId) {
      return dhEdit({}, macroNode);
    } else if (macroName === MACRO_GADGET_NAME) {
      //} && !macroParams.gadgetId) {
      return dhEditGadget({}, macroNode);
    }

    var dialog = new AJS.Dialog({
      width: 600,
      height: 280,
      id: "dashboardhub-macro-dialog",
      closeOnOutsideClick: false
    }); // dialog content

    var macroSettings = _objectSpread({
      boardId: '',
      width: '100%',
      // IMAGE_WIDTH,
      height: IMAGE_HEIGHT
    }, macroParams);

    dialog.addHeader(AJS.I18n.getText("dashboardhub.settings.dialog.title"));
    var dialogParams = {
      settings: _objectSpread({}, macroSettings, {
        boardToken: encodeURIComponent(macroSettings.boardToken)
      }),
      urlBase: URL_BASE
    };
    dialog.addPanel("", dhSoy.macro.editParamsForm(dialogParams), "");
    dialog.addSubmit(AJS.I18n.getText("dashboardhub.settings.save.button"), function (dialog) {
      // Reads new values and validate them
      var width = $("#dashboardhub-macro-width").attr("value");
      var height = $("#dashboardhub-macro-height").attr("value");

      if (!width.match(/^(100%|\d*)(px)?$/)) {
        $("#dashboardHubDialogMessageContainer").html(AJS.I18n.getText('dashboardhub.settings.board.width.badFormat'));
        return;
      } else if (!height.match(/^(\d*)(px)?$/)) {
        $("#dashboardHubDialogMessageContainer").html(AJS.I18n.getText('dashboardhub.settings.board.height.badFormat'));
        return;
      }

      if (macroSettings.width !== width || macroSettings.height !== height) {
        var macroRenderRequest = {
          contentId: Confluence.Editor.getContentId(),
          macro: {
            name: macroName,
            params: _objectSpread({}, macroSettings, {
              width: width,
              height: height
            }),
            defaultParameterValue: "",
            body: ""
          }
        };
        tinymce.confluence.MacroUtils.insertMacro(macroRenderRequest).always(function () {
          return dialog.remove();
        });
      } else {
        dialog.remove();
      }
    });
    dialog.addCancel(AJS.I18n.getText("dashboardhub.settings.close.button"), function (dialog) {
      dialog.remove();
    });
    dialog.popup.element.css('zIndex', 3000);
    dialog.popup.element.css('marginTop', -250);
    dialog.show();
  };

  var macroResize = function macroResize(macroNode, aspect) {
    var params = getMacroParams(macroNode);
    params.width = aspect == 100 ? aspect + '%' : IMAGE_WIDTH * aspect / 100;
    params.height = IMAGE_HEIGHT * aspect / 100;
    var macroRenderRequest = {
      contentId: Confluence.Editor.getContentId(),
      macro: {
        name: macroNode.getAttribute('data-macro-name'),
        params: params,
        defaultParameterValue: "",
        body: ""
      }
    };
    tinymce.confluence.MacroUtils.insertMacro(macroRenderRequest, macroNode);
  };

  setTimeout(function () {
    if (AJS.Confluence.PropertyPanel.Macro) {
      AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("dh-edit-board", dhEdit);
      AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("dh-edit-gadget", dhEditGadget);
      AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("dh-size-small", function (e, macroNode) {
        macroResize(macroNode, 25);
      });
      AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("dh-size-medium", function (e, macroNode) {
        macroResize(macroNode, 50);
      });
      AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("dh-size-large", function (e, macroNode) {
        macroResize(macroNode, 75);
      });
      AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("dh-size-full-width", function (e, macroNode) {
        macroResize(macroNode, 100);
      });
    } else {
      console.error('DH macro - registerButtonHandler function is not present');
    }
  }, 300);
  AJS.MacroBrowser.setMacroJsOverride(MACRO_DASHBOARD_NAME, {
    opener: dhEditMacro
  });
  AJS.MacroBrowser.setMacroJsOverride(MACRO_GADGET_NAME, {
    opener: dhEditMacro
  });
})();