/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.statusPage;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.model.TimeRange;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.JSMDataUtil2;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.statusPage.StatusPageGadgetRequesterBase;
import com.roninpixels.dashboardhub.gadgetsRequesters.statusPage.util.HistoricalUptimeConfig;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class HistoricalUptime
extends StatusPageGadgetRequesterBase {
    private static final Logger log = LoggerFactory.getLogger(HistoricalUptime.class);
    private static final int INCIDENTS_LIMIT = 100;
    private static final List<String> STATUSES = Arrays.asList("normal", "scheduled", "in_progress", "verifying", "investigating", "identified", "monitoring", "resolved");

    List retrieveIncidents(String pageId, Map params) throws Exception {
        ResponseEntity<String> resp = this.statusPageConnector.getPageIncidents(pageId, params);
        return this.checkStatusAndParse(resp, List.class);
    }

    List getIncidents(HistoricalUptimeConfig config) throws Exception {
        DateTime startDate = JSMDataUtil2.getDate(config.getTimeRange());
        LinkedList collectedIncidents = new LinkedList();
        boolean moreData = true;
        int pageNumber = 1;
        while (collectedIncidents.size() < 100 && moreData) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("limit", "100");
            params.put("page", "" + pageNumber);
            List incidents = this.retrieveIncidents(config.getPage(), params);
            moreData = !incidents.isEmpty();
            collectedIncidents.addAll(incidents.stream().filter(incident -> {
                DateTime createdAt = DateTime.parse((String)((String)incident.get("created_at")));
                return createdAt.isAfter((ReadableInstant)startDate);
            }).collect(Collectors.toList()));
            ++pageNumber;
        }
        return collectedIncidents.stream().sorted((o1, o2) -> {
            DateTime date1 = DateTime.parse((String)((String)o1.get("created_at")));
            DateTime date2 = DateTime.parse((String)((String)o2.get("created_at")));
            return date2.compareTo((ReadableInstant)date1);
        }).collect(Collectors.toList());
    }

    List parseIncidents(List<Map> incidents) {
        List updates = incidents.stream().map(incident -> (List)incident.get("incident_updates")).flatMap(Collection::stream).sorted((u1, u2) -> {
            DateTime date1 = DateTime.parse((String)((String)u1.get("display_at"))).toDateTime(DateTimeZone.UTC);
            DateTime date2 = DateTime.parse((String)((String)u2.get("display_at"))).toDateTime(DateTimeZone.UTC);
            return date1.compareTo((ReadableInstant)date2);
        }).collect(Collectors.toList());
        if (updates.isEmpty()) {
            return Collections.emptyList();
        }
        DateTime startCalendar = DateTime.parse((String)((String)((Map)updates.get(0)).get("display_at"))).toDateTime(DateTimeZone.UTC).withTimeAtStartOfDay();
        DateTime endCalendar = DateTime.parse((String)((String)((Map)updates.get(updates.size() - 1)).get("display_at"))).toDateTime(DateTimeZone.UTC);
        LinkedList calendar = new LinkedList();
        DateTime tmp = startCalendar;
        while (tmp.isBefore((ReadableInstant)endCalendar)) {
            HashMap<String, Object> day = new HashMap<String, Object>();
            day.put("date", tmp);
            day.put("st", tmp.toString("dd MM YYYY"));
            day.put("status", 0);
            day.put("incidents", new LinkedList());
            calendar.add(day);
            tmp = tmp.plusDays(1);
        }
        incidents.stream().forEach(incident -> {
            List incidentUpdates = (List)incident.get("incident_updates");
            block0: for (int i = incidentUpdates.size() - 1; i >= 0; --i) {
                DateTime endDay;
                Map update = (Map)incidentUpdates.get(i);
                String updateStatus = (String)update.get("status");
                String status = updateStatus.equals("completed") ? "resolved" : updateStatus;
                int currentStatus = STATUSES.indexOf(status);
                DateTime initDay = DateTime.parse((String)((String)update.get("display_at"))).toDateTime(DateTimeZone.UTC).withTimeAtStartOfDay();
                if (status.equals("resolved")) {
                    endDay = new DateTime((Object)initDay);
                } else if (i - 1 >= 0) {
                    Map nextUpdate = (Map)incidentUpdates.get(i - 1);
                    endDay = DateTime.parse((String)((String)nextUpdate.get("display_at"))).toDateTime(DateTimeZone.UTC).withTimeAtStartOfDay();
                    if (endDay.isBefore((ReadableInstant)initDay)) {
                        endDay = new DateTime((Object)initDay);
                    }
                } else {
                    DateTime endCalendarDate = (DateTime)((Map)calendar.get(calendar.size() - 1)).get("date");
                    endDay = new DateTime((Object)endCalendarDate);
                }
                String incidentName = (String)incident.get("name");
                HashMap<String, String> incidentResume = new HashMap<String, String>();
                incidentResume.put("name", incidentName);
                incidentResume.put("link", (String)incident.get("shortlink"));
                for (Map day : calendar) {
                    DateTime currentDT = ((DateTime)day.get("date")).withTimeAtStartOfDay();
                    if (initDay.getMillis() <= currentDT.getMillis() && currentDT.getMillis() <= endDay.getMillis()) {
                        List dayIncidents = (List)day.get("incidents");
                        if (!dayIncidents.stream().anyMatch(aDayIncident -> aDayIncident.get("name").equals(incidentName))) {
                            dayIncidents.add(incidentResume);
                        }
                        if ((Integer)day.get("status") >= currentStatus) continue;
                        day.put("status", currentStatus);
                        continue;
                    }
                    if (endDay.getMillis() >= currentDT.getMillis()) continue;
                    continue block0;
                }
            }
        });
        return calendar;
    }

    List<Map> getCalendar(HistoricalUptimeConfig config) throws Exception {
        List incidents = this.getIncidents(config);
        List parsedIncidents = this.parseIncidents(incidents);
        return parsedIncidents;
    }

    private void ensureTimeRange(HistoricalUptimeConfig config) {
        if (config.getTimeRange() == null) {
            TimeRange tr = new TimeRange();
            tr.setAmount(1);
            tr.setRange("week");
            config.setTimeRange(tr);
        }
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        HistoricalUptimeConfig config = GadgetRequesterUtils.getConfig(gadget, HistoricalUptimeConfig.class);
        this.ensureTimeRange(config);
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("pageInfo", this.getPage(config.getPage()));
            data.put("calendar", this.getCalendar(config));
            return data;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            log.error("Something went wrong", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

