/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk;

import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.JSMBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.configs.JQLFilterConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.configs.JSMMultiprojectConfig;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JSMMultiproject
extends JSMBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(JSMMultiproject.class);

    protected List getQueueIssuesByTimeRange(String dateStr, String queueJQL, List fields) {
        String jql = String.format("(created >= '%s' OR updatedDate >= '%s') AND (%s)", dateStr, dateStr, queueJQL);
        return this.execJQLwithFilterFields(jql, fields, null, null, null, null);
    }

    protected List<Map> getQueues(JSMMultiprojectConfig config) {
        List<Map> queues = config.getProjectsQueues().stream().map(projectQueue -> {
            try {
                String projectId = (String)projectQueue.get("project");
                String queueId = (String)projectQueue.get("queue");
                return this.getQueue(projectId, queueId);
            }
            catch (Exception e) {
                throw new RuntimeException("Problems getting data", e);
            }
        }).collect(Collectors.toList());
        return queues;
    }

    protected Map getJqlQueues(JSMMultiprojectConfig config) {
        JQLFilterConfig jqlFilterConfig;
        LinkedHashMap<String, Object> jqlQueuesMap = new LinkedHashMap<String, Object>();
        if (config instanceof JQLFilterConfig && (jqlFilterConfig = (JQLFilterConfig)config).getUseJQL() != null && jqlFilterConfig.getUseJQL().booleanValue()) {
            jqlQueuesMap.put("jql", jqlFilterConfig.getJql().toLowerCase().split("order by")[0]);
            jqlQueuesMap.put("queues", new LinkedList());
            return jqlQueuesMap;
        }
        if (config.getProjectsQueues() == null) {
            config.setProjectQueue(config.getProject(), config.getQueue());
        }
        List<Map> queues = this.getQueues(config);
        String queuesJql = queues.stream().map(queueJql -> queueJql.get("jql").toString().split("ORDER BY")[0]).collect(Collectors.joining(" OR "));
        jqlQueuesMap.put("jql", queuesJql);
        jqlQueuesMap.put("queues", queues);
        return jqlQueuesMap;
    }

    @Override
    public abstract Object getData(GadgetModel var1, List<String> var2);
}

