/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.atlassianInsight;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.AtlassianInsightConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequester;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

public abstract class AtlassianInsightGadgetRequesterBase
implements GadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(AtlassianInsightGadgetRequesterBase.class);
    @Inject
    private ConnectorsProvider provider;
    AtlassianInsightConnector connector;
    private ObjectMapper mapper = new ObjectMapper();
    protected Map context;

    @Override
    public void init(DatasourceModel datasource, Map context) {
        this.connector = (AtlassianInsightConnector)this.provider.getConnector(datasource);
        if (this.connector == null) {
            throw new IllegalArgumentException("Datasource is not valid for gadget requester: " + this.getClass().getAnnotation(Component.class));
        }
        this.context = context;
    }

    protected void checkStatus(ResponseEntity response) {
        if (response.getStatusCode().value() >= 400) {
            throw new BadRequestToSourceException(response);
        }
    }
}

