/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.confluence.license;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.core.util.Clock;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.roninpixels.dashboardhub.license.DHLicenseRule;
import com.roninpixels.dashboardhub.license.LicenseStatusJsonBean;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class CustomDashboardsRule
implements DHLicenseRule {
    private static final long MAX_VALUE = 1704119196847L;
    static final String PLG_KEY = "com.simplenia.confluence.plugins.customdashboards";
    @Inject
    @ComponentImport
    private LicenseService licenseSrv;
    @Inject
    @ComponentImport
    private PluginLicenseManager licenseManager;
    @Inject
    @ComponentImport
    private PluginAccessor pluginAccessor;
    @Inject
    @ComponentImport
    private Clock clock;

    @Override
    public boolean isLicensed() {
        boolean isValid = !this.licenseSrv.isLicensedForDataCenter() && this.clock.getCurrentDate().getTime() < 1704119196847L && this.pluginAccessor.getPlugin(PLG_KEY) != null;
        return isValid;
    }

    @Override
    public LicenseStatusJsonBean getLicenseStatus() {
        String key = this.licenseManager.getPluginKey();
        LicenseStatusJsonBean bean = new LicenseStatusJsonBean();
        bean.setValid(this.isLicensed());
        bean.setKey(key);
        return bean;
    }
}

