/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.confluence.dashboardfilters.controllers.impl;

import com.atlassian.activeobjects.tx.Transactional;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.DHDashboardFilterRulesRepository;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.controllers.DashboardFilterRulesController;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.web.models.DashboardFilterRule;
import com.roninpixels.dashboardhub.confluence.exceptions.InvalidFilterRuleException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class DashboardFilterRulesControllerImpl
implements DashboardFilterRulesController {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardFilterRulesControllerImpl.class);
    public static final int USER_GROUPS_MAX_LENGTH = 2048;
    @Inject
    private DHDashboardFilterRulesRepository filterRulesRepo;
    private final ObjectMapper mMapper = new ObjectMapper();

    @Override
    public List<DashboardFilterRule> getDashboardFilterRules() {
        List<DashboardFilterRule> dashboardFilterRules = this.filterRulesRepo.getAllDashboardFilterRules();
        dashboardFilterRules.sort(Comparator.comparing(a -> a.getPriority()));
        return dashboardFilterRules;
    }

    @Override
    public void setDashboardFilterRules(List<DashboardFilterRule> dashboardFilterRules) throws InvalidFilterRuleException {
        this.resetDashboardFilterRules();
        if (dashboardFilterRules != null) {
            for (DashboardFilterRule filterRule : dashboardFilterRules) {
                this.validateFilterRule(filterRule);
                this.filterRulesRepo.addDashboardFilterRule(filterRule);
            }
        }
    }

    @Override
    public void resetDashboardFilterRules() {
        List<DashboardFilterRule> dashboardFilterRules = this.filterRulesRepo.getAllDashboardFilterRules();
        if (dashboardFilterRules != null) {
            for (DashboardFilterRule filterRule : dashboardFilterRules) {
                this.filterRulesRepo.removeDashboardFilterRule(filterRule.getKey());
            }
        }
    }

    @Override
    public DashboardFilterRule getDashboardFilterRule(String key) {
        return this.filterRulesRepo.getDashboardFilterRule(key);
    }

    @Override
    public DashboardFilterRule setDashboardFilterRule(DashboardFilterRule dashboardFilterRule) throws InvalidFilterRuleException {
        this.validateFilterRule(dashboardFilterRule);
        List<DashboardFilterRule> dashboardFilterRules = this.getDashboardFilterRules();
        if (dashboardFilterRules == null) {
            dashboardFilterRules = new ArrayList<DashboardFilterRule>();
        }
        dashboardFilterRule.setLastModified(new Date());
        if (StringUtils.isBlank((String)dashboardFilterRule.getKey())) {
            dashboardFilterRule.setKey(this.getRandomUUID());
            dashboardFilterRules.add(dashboardFilterRule);
        } else {
            ListIterator<DashboardFilterRule> it = dashboardFilterRules.listIterator();
            while (it.hasNext()) {
                DashboardFilterRule filterRule = it.next();
                if (!filterRule.getKey().equals(dashboardFilterRule.getKey())) continue;
                it.set(dashboardFilterRule);
            }
        }
        this.reorderFilterPriorities(dashboardFilterRules);
        this.renumberFilterPriorities(dashboardFilterRules);
        this.setDashboardFilterRules(dashboardFilterRules);
        return dashboardFilterRule;
    }

    @Override
    public boolean removeDashboardFilterRule(String key) throws InvalidFilterRuleException {
        List<DashboardFilterRule> dashboardFilterRules = this.getDashboardFilterRules();
        if (dashboardFilterRules != null) {
            ListIterator<DashboardFilterRule> it = dashboardFilterRules.listIterator();
            while (it.hasNext()) {
                DashboardFilterRule filterRule = it.next();
                if (!filterRule.getKey().equals(key)) continue;
                it.remove();
                this.renumberFilterPriorities(dashboardFilterRules);
                this.setDashboardFilterRules(dashboardFilterRules);
                return true;
            }
        }
        return false;
    }

    private void reorderFilterPriorities(List<DashboardFilterRule> dashboardFilterRules) {
        if (dashboardFilterRules != null && !dashboardFilterRules.isEmpty()) {
            dashboardFilterRules.sort(Comparator.comparingInt(DashboardFilterRule::getPriority).thenComparing((d1, d2) -> d2.getLastModified().compareTo(d1.getLastModified())));
        }
    }

    private void renumberFilterPriorities(List<DashboardFilterRule> dashboardFilterRules) {
        if (dashboardFilterRules != null && !dashboardFilterRules.isEmpty()) {
            int priority = 1;
            for (DashboardFilterRule filterRule : dashboardFilterRules) {
                filterRule.setPriority(priority++);
            }
        }
    }

    private void validateFilterRule(DashboardFilterRule filterRule) throws InvalidFilterRuleException {
        String usersAndGroupsRestricted;
        String string = usersAndGroupsRestricted = filterRule.getUsersAndGroupsRestricted() != null ? String.join((CharSequence)",", filterRule.getUsersAndGroupsRestricted()) : "";
        if (usersAndGroupsRestricted.length() > 2048) {
            throw new InvalidFilterRuleException("Filter Rule usersAndGroupsRestricted validation error");
        }
    }

    private String getRandomUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }
}

