/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.jira.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.services.controllers.JiraDatasourcesController;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.rest.jira.api.GenericJiraEndpoint;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

@Path(value="/jira/v1/globalConfiguration")
public class GlobalConfigurationEndpoint {
    private static final Logger log = LoggerFactory.getLogger(GlobalConfigurationEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;
    @Inject
    private JiraDatasourcesController jiraDatasourcesController;

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response get(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            DatasourceModel datasourceModel = this.connProvider.getDatasourceFrom(datasourceinfo);
            JiraConnector jiraConnector = this.jiraDatasourcesController.getJiraConnector(datasourceModel);
            ResponseEntity<String> response = jiraConnector.configuration();
            return GenericJiraEndpoint.generateResponse(response, null);
        }
        catch (Exception e) {
            log.error("Problems getting configuration settings", (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

