/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers;

import com.roninpixels.dashboardhub.services.ApplicationPropertiesAccesor;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.model.AppUser;
import com.roninpixels.dashboardhub.utils.TokenGenerator;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class BoardTokenController {
    @Inject
    private TokenGenerator tokenGenerator;
    @Inject
    private DHUserService dhUserService;
    @Inject
    private ApplicationPropertiesAccesor applicationProperties;

    public BoardModel updateToken(BoardModel board) {
        AppUser user = this.dhUserService.getLoggedInUser();
        String ownerKey = board.getOwner() != null ? board.getOwner() : user.getKey();
        TokenContentModel tc = new TokenContentModel();
        tc.setBoardId(board.getId());
        tc.setGlobal(board.getGlobal());
        tc.setUsserAccountId(ownerKey);
        tc.setProduct(this.applicationProperties.getDisplayName());
        String token = this.tokenGenerator.generate(tc);
        board.setToken(token);
        return board;
    }

    public String getToken(String id, boolean global) {
        AppUser user = this.dhUserService.getLoggedInUser();
        TokenContentModel tc = new TokenContentModel();
        tc.setBoardId(id);
        tc.setGlobal(global);
        tc.setUsserAccountId(user.getKey());
        tc.setProduct(this.applicationProperties.getDisplayName());
        return this.tokenGenerator.generate(tc);
    }
}

