
const b64DecodeUnicode = (str) => {
    return decodeURIComponent(atob(str).split('').map(function(c) {
        return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2);
    }).join(''));
};

/*
    This function load the base64 app config which includes the permissions
    and restricted access.
*/
const loadAppConfig = (base64AppConfig, isAPortalCustomer) => {
    const appConfigStr = b64DecodeUnicode(base64AppConfig);
    const appConfig = JSON.parse(appConfigStr);

    window.appConfig = appConfig;
    window.appAllowedUserGroups = appConfig.appAllowedUserGroups || [];
    window.restrictedAccess = appConfig.restrictedAccess === true;
}

const loadConfig = ({
    base64Config,
    base64AppConfig,
    imagesPath,

    // used by customer portal
    isAPortalCustomer,
    customerBoards,

    // used by jira dashboards features
    notExternalWindow,
    containerData,
    gadget,
    isGadgetView,

    // confluence - macros
    macroBoard,
}) => {
    const configString = b64DecodeUnicode(base64Config);
    const config = JSON.parse(configString);

    // load configuration from server
    window.isExternal = notExternalWindow ? false : config.isExternal;
    window.jsdPortal = config.jsdPortal;
    window.instanceInfo = config.instanceInfo;
    window.dashboardHub = config.dashboardHub;
    window.sessionData = config.sessionData;
    window.dhError = config.dhError;
    // set some URLs
    window.dashboardHub.imagesPath = imagesPath;

    // set app config: restrictions
    if (base64AppConfig) {
        loadAppConfig(base64AppConfig);
    }

    // **** shared dashboards
    if (config.protectedWallboard) {
        window.protectedWallboard = config.protectedWallboard;
    }
    if (config.wallboard) {
        window.wallboard = JSON.parse(config.wallboard);
    }
    if (config.sharedBoard) {
        window.sharedBoard = JSON.parse(config.sharedBoard);
    }

    // **** Confluence macros
    if ( macroBoard ) {
        window.macroBoard = JSON.parse(b64DecodeUnicode(macroBoard));
    }

    // **** this fragment are used on Jira Dashboards
    if (containerData) {
        window.containerData = JSON.parse(b64DecodeUnicode(containerData));
    }
    if (gadget) {
        window.gadget = JSON.parse(b64DecodeUnicode(gadget));
    }
    if (isGadgetView) {
        window.isGadgetView = true;
    }

    // **** customerPortal
    if (customerBoards) {
        window.customerPortal = true;
        window.dashboardHub.readOnly = true;
        window.customerBoards = JSON.parse(b64DecodeUnicode(customerBoards));
        window.dashboardHub.mode = 'customerPortal';
    }
    if ( isAPortalCustomer ) {
        window.dashboardHub.readOnly = isAPortalCustomer;
    }
}

window.dhTools = {
    b64DecodeUnicode,
    loadConfig
}
